// wallFollow.c
// ****************************************************
// File: wallFollow.c
// Date: 11/23/2001
// Last modified: 02/16/2002
// Author: Karl McEntire
// Program: Smart wall following algorithm 
// ****************************************************

//Setup ID numbers
#define wallFORM 			6000
#define wallStartBUTTON 	6001
#define wallExitBUTTON 		6002
#define wallInstructLBL1 	6030
#define wallInstructLBL2 	6031
#define wallInstructLBL3 	6032

int wallState() {

	// create binary state number
	// 0 = too close
	// 1 = just right
	// 2 = too far away
	//
	// 				 sensor
	//			  front	  back
	//	state		2		1		Action
	//	-----		-		-		------
	//	  0	  		0		0		vector away  0 rad
	//	  1	  		0		1		turn right	
	//	  2			0		2		turn right
	//	  4			1		0		no change
	//	  5			1		1		no change
	//	  6			1		2		no change
	//	  8			2		0		turn left
	//	  9			2		1		turn left
	//	 10			2		2		vector closer  - PI / 3

	int i, sensor[3], s[3] ;
	int min = 24, max = 21 ;  					// sensor range
				
	for( i = 1 ; i < 3 ; i++ ) {				// look at sensors 1 and 2

		sensor[i] = IrVal( i ) ;  
	
		if ( sensor[i] > min ) s[i] = 0 ;		// use reverse boolean logic when using IrVal
		else if ( sensor[i] < max ) s[i] = 2 ;	// use reverse boolean logic when using IrVal
		else s[i] = 1 ;
	}
	
	return ( s[2] * 4 + s[1] ) ;  				// return state 
}


waller() {  
	int sensor[3] ;
	int state, oldstate ;

	float vel = 4.0 ; 				// go at inches per second
	float velSlow = 1.0 ;			// go slow

	float head  ;  					// current heading, start at -30 degrees
	float headIn ;			  		// heading to vector toward wall
	float headOut ;					// heading to vector away from wall

	float omega = -0.00 ;			// 0=no spin, -0.05=bias toward wall
	float omegaIn = -0.15 ;			// turn toward wall
	float omegaInFast = -0.3 ;		// turn toward wall quickly
	float omegaOut = 0.15 ;			// turn away from wall
	float omegaTurn = 0.5 ;			// turn quickly

	head = - 2 * PI / 12 ;			// normal heading parallel to wall and perpendicular to servo 3
	headIn = - 4 * PI / 12 ;		// vector toward wall
	headOut = 0 * PI / 12 ;			// heading to vector away from wall
	
	headingDriver( vel, head, omega );  // starting heading perpendicular to servo 3

	while( 2 != event(2) ) {  			// continue unless pen tap

		oldstate = state ;
		state = wallState() ;
		
		if( state == oldstate ) { 	// did the oldstate sensor change?
			continue ;  			// loop until state changes
		} 
//		puts(state+"\t");
		switch( state ) {
			case 0: 				// both sensors too close - vector away w/ turn - inside corner?
				headingDriver( velSlow, headOut, omegaTurn ) ;
//				puts("too close headout\n");
				break ;	
			case 1: 				// front sensor too close - turn right - same as next state
			case 2: 				// turn right
				headingDriver( velSlow , headOut, omegaTurn ) ;
//				puts("front too close - headout\n");
				break ;
			case 4: 				// front sensor ok, back sensor too close
			case 5: 				// front sensor ok, back sensor ok
			case 6: 				// front sensor ok, back sensor too far
									// in any case we should continue since we see a wall in front
									// continue parallel to wall
				headingDriver( vel, head, omega );
//				puts("OK go parallel\n");
				break ;
			case 8: 				// front sensor too far from wall or ran out of wall
									// back sensor too close - still have wall
									// vector away with a rotation back toward wall
				headingDriver( vel, headOut, omegaInFast ) ;
//				puts("F too far, B too close, turn in\n");
				break ;
			case 9: 				// go around corner
									// no wall in front, just right in back, start a turn
//				puts("F too far, B ok - frog in\n") ;
//				Drive( 115, 115, 0 ) ;  // drive to point sensor 2 at wall or corner
//				headingDriver( velSlow, head, omegaInFast ) ;  
//				break ;				
			case 10: 				// both sensors too far from wall - vector in
//				puts("BF too far, headin / turn\n") ;
				headingDriver( vel, headIn, omegaInFast ) ;  
				break ;		
		}
	}
}	
	
wallFollow() {
	int e;
		
	Form(wallFORM,"Wall Follower      ");
	
	//buttons	
	Button(wallExitBUTTON,0x10,120,140,0,0,"Exit");
	Button(wallStartBUTTON,0x00,40,140,0,0,"Start");
	Label(wallInstructLBL1,5,60,"Place servo 3 next to wall follow left.");
	Label(wallInstructLBL2,20,70,"Tap Start button to begin.");
	Label(wallInstructLBL3,30,80,"Tap screen to stop.");

	Fctl(DRAW,wallFORM); //draw objects

	while(1) {
		e=Fevent(1);
		switch(e) {
			case wallExitBUTTON: 
				StopRobot();
				return;
			case wallStartBUTTON: 
				portOpen();
				waller();
				StopRobot() ;
				portClose() ;
				break;
		}
	}
}
	
