// spinWallFol.c
// ****************************************************
// File: spinWallFol.c
// Date: 11/26/2001
// Last modified: 02/16/2002
// Author: Karl McEntire
// Program: spin next to a wall measuring the distance
//			from each sensor and vector along the wall
//			to the right (wall follow right).
// ****************************************************

//Setup ID numbers
#define spinFORM 			6000
#define spinStartBUTTON 	6001
#define spinExitBUTTON 		6002
#define spinInstructLBL1 	6030
#define spinInstructLBL2 	6031
#define spinInstructLBL3 	6032

spinner() {
	
	int dmin, i ;
	float ttot, velX[3], velY[3], vel ;
	float omega, fudge ;  				// omega/2*PI revolutions per sec
										// fudge begins new vector early to
										// ensure forward movement along wall 

	omega = 1.0 ;  		// rotational velocity in 2*PI rotations per sec?
	fudge = PI / 6 ; 	// don't vector so quick to the wall - move along wall
	vel = 1.65 ; 		// set to max velocity not getting maxServo errors
	dmin = 40 ; 		// min distance away from wall

	for( i=0; i<3; i++ ) {  // vector directions perpendicular to sensor
		velX[i] = - cos( i * 2 * PI / 3 + fudge ) * vel ;
		velY[i] =  sin( i * 2 * PI / 3 + fudge) * vel ; 
	}

	Driver( 0, 0, - omega ) ; 		// start spining

	while( 2 != event(2) ) 							// continue until pen event
	  for( i=0; i<3; i++ ) 
		if( IrVal( i+1 ) >= dmin ) 					// look for a wall
			Driver( velX[i], velY[i], - omega ) ;	// set vector perpendicular to sensor
}

spinWallFol() {
	int e;
		
	Form(spinFORM,"Spin Wall Follow  ");
	
	//buttons	
	Button(spinExitBUTTON,0x10,120,140,0,0,"Exit");
	Button(spinStartBUTTON,0x00,40,140,0,0,"Start");
	Label(spinInstructLBL1,10,60,"Bot spins and follows wall left.");
	Label(spinInstructLBL2,20,70,"Tap Start button to begin.");
	Label(spinInstructLBL3,30,80,"Tap screen to stop.");

	Fctl(DRAW,spinFORM); //draw objects

	while(1) {
		e=Fevent(1);
		switch(e) {
			case spinExitBUTTON: 
				StopRobot();
				return;
			case spinStartBUTTON: 
				portOpen();
				spinner();
				StopRobot() ;
				portClose();
				break;
		}
	}
}
