// servoDriver.c   
// ****************************************************
// File: servoDriver.c
// Date: 11/14/2001
// Last modified: 12/02/2001
// Author: Karl McEntire
// Program: Servo driver functions including vector math 
//			to calculate angular velocity of each 
//			servo wheel and execute change to each wheel.
// ****************************************************


Drive(int vel1, int vel2, int vel3) {
	TxString("SV1M"+vel1+"SV2M"+vel2+"SV3M"+vel3);
}

Driver(float velX, float velY, float omega ) {
	int i ;
	float tOmega[NumServos] ; 			// rotational velocity of each wheel
	float vProduct[NumServos] ;				// result for multiplication of two vectors
	float svoVectorX[NumServos];
	float svoVectorY[NumServos];
	string cmd;
	cmd = "";
	
	for (i=0; i<NumServos; i++) {
		svoVectorX[i] = cos( omega + vectConst * i ) ;
		svoVectorY[i] = -sin( omega + vectConst * i );
		vProduct[i] = svoVectorX[i] * velX + svoVectorY[i] * velY ;
		tOmega[i] = ( vProduct[i] + robotBaseWidth * omega ) / ( robotWheelRadius * PI * 2 ) ;	
		cmd = cmd + "SV" + (string)(i+1) + "M" + (string)RevToVal(tOmega[i]);
	}		
	TxString(cmd);		// transmit command to servo board
}	

holoDriver(float velX, float velY, float omega, float tElapsed) {
	int i ;
	float tOmega[NumServos] ; 			// rotational velocity of each wheel
	float vProduct[NumServos] ;				// result for multiplication of two vectors
	float svoVectorX[NumServos];
	float svoVectorY[NumServos];
	string cmd;
	cmd = "";
	
	for (i=0; i<NumServos; i++) {
		svoVectorX[i] = cos(tElapsed * omega + vectConst * i) ;
		svoVectorY[i] = -sin(tElapsed * omega + vectConst * i);
		vProduct[i] = svoVectorX[i] * velX + svoVectorY[i] * velY ;
		tOmega[i] = ( vProduct[i] + robotBaseWidth * omega ) / ( robotWheelRadius * PI * 2 ) ;	
		cmd = cmd + "SV" + (string)(i+1) + "M" + (string)(int)RevToVal(tOmega[i]);
	}		
	TxString(cmd);		// transmit command to servo board
}	


// Turn in rotations per second - positive number turns CW

Turn( float omega ) {
	Driver( 0, 0, omega ) ;
}

//  run bot in polar coordinates: heading and speed 
//  accepts velocity and heading

headingDriver( float vel, float heading, float omega ) {
	float velX, velY ;  
	velX = sin(heading) * vel ;
	velY = cos(heading) * vel ;
	Driver( velX, velY, omega ) ;
}

// stops bot
StopRobot() {
	Drive( 0,0,0 ) ;
}
