// XYfollow.c
// ****************************************************
// File: XYfollow.c
// Date: 11/27/2001
// Last modified: 02/16/2002
// Author: Karl McEntire
// Program: Draw a scribble on the Pilot and have the
//			bot follow it.
// ****************************************************

//Setup ID numbers
#define xyFORM 			7000
#define xyStartBUTTON 	7001
#define xyExitBUTTON 	7002
#define xyInstructLBL1 	7030
#define xyInstructLBL2 	7031
#define xyInstructLBL3 	7032
#define ERASE 0

XY() {
   	int e, x, y ;
   	int N = 100 ;  // maximum number of xy locations
   	int xArray[100], yArray[100] ;
   	int cnt = 0, i ;
	float vel = 4.0, dist ;  // vel - velocity inch / sec
	float velX, velY, dur, relX[100], relY[100] ; 
	
	// Get a scribble - draw on screen and capture x, y locations
 	while( event(2) != 2 ) continue ;	// wait for pen down 
	// Get initial position
	x = penx();
	y = peny();

   	// Draw lines until we stop receiving penMoves
	do {

  		// record x, y into an array
  		xArray[cnt] = x ;
  		yArray[cnt] = y ;
  
  		// draw the line on the pilot
  		line( 1, x, y, x=penx(), y=peny() );
  
		cnt++ ;
   	} 
	while ( event(1) == 4 && cnt < N );
	

	for( i = 0; i < cnt-1; i++ ) {
		relX[i] = xArray[i+1] - xArray[i] ;
		relY[i] = yArray[i+1] - yArray[i] ;
	}

	rect(ERASE, 0, 15, 159, 159, 0) ;  // erase the scibble
	
	for( i = 0; i < cnt-1; i++ ) { // use pixels as the distance & move bot to match scrible on screen
		dist = sqrt( relX[i]*relX[i] + relY[i]*relY[i] ) ; // calc the length of the move
		if ( dist != 0 ) {  // don't move if no pen movement & avoid divide by zero
			velX = relX[i] * vel / dist ;		// calculate the velocity vector components
			velY = relY[i] * vel / dist ;
			dur = dist / vel ;  // calculate the duration of the move
   			line( 1, xArray[i], yArray[i], xArray[i+1], yArray[i+1] ) ;
			Driver( - velX, velY, 0 ) ;  // tell the bot to go there, change signs to match pilot orientation to bot
			sleep( dur * 1000 ) ; // time allowed for the bot to make each move
		}
	}
	sleep(1000); // sleep for a second then erase the display
	rect(ERASE, 0, 15, 159, 159, 0) ;  // erase the scibble redraw
}

XYfollow() {
	int e;
		
	Form(xyFORM,"Scribble Follow  ");
	
	//buttons	
	Button(xyExitBUTTON,0x10,120,140,0,0,"Exit");
	Button(xyStartBUTTON,0x00,40,140,0,0,"Start");
	Label(xyInstructLBL1,30,60,"Bot follows a scribble.");
	Label(xyInstructLBL2,20,70,"Tap Start button to begin.");
	Label(xyInstructLBL3,20,80,"Draw a scribble on the screen.");

	Fctl(DRAW,xyFORM); //draw objects

	while(1) {
		e=Fevent(1);
		switch(e) {
			case xyExitBUTTON: 
				StopRobot();
				return;
			case xyStartBUTTON: 
				Fctl(HIDEALL);
				portOpen();
				XY();
				StopRobot() ;
				portClose();
//				Fctl(DRAW,xyFORM); //redraw form
				Fctl(SHOWALL);
				break;
		}
	}
}
