/* ras.h: global definitions for Sun's raster picture file format */

#ifndef RAS_HDR
#define RAS_HDR

/* $Header: ras.h,v 1.1 88/12/18 20:29:32 ph Locked $ */

/* the following is modified from Sun's /usr/include/rasterfile.h: */

typedef struct {	/* RAS FILE HEADER */
    long magic;		/* magic number */
    long dx;		/* width in pixels */
    long dy;		/* height in pixels */
    long nbit;		/* number of bits per pixel (1, 8, or 24) */
    long len;		/* length of image data in bytes */
    long type;		/* type of file; see RAS_TYPE_* below */
    long cmtype;	/* type of colormap; see RMT_* below */
    long cmlen;		/* length (bytes) of following map */
} Ras_head;

#define	RAS_MAGIC	0x59a66a95

/* Sun supported ras types */
#define RAS_TYPE_OLD		0	/* Raw pixrect image? */
#define RAS_TYPE_STANDARD	1	/* Raw pixrect image */
#define RAS_TYPE_BYTE_ENCODED	2	/* Run-length compression of bytes */
#define RAS_TYPE_EXPERIMENTAL 0xffff	/* Reserved for testing */

/* Sun registered cmtypes */
#define RAS_CM_RAW		2

/* Sun supported cmtypes */
#define RAS_CM_NONE		0	/* ras_maplength is expected to be 0 */
#define RAS_CM_EQUAL_RGB	1	/* red[cmlen/3],green[],blue[] */

/*----------------------------------------------------------------------*/

#include <dump.h>

typedef Dump Ras;	/* A RAS IS A DUMP */

Ras *ras_open(/* file, mode */);
void ras_set_box(/* p, ox, oy, dx, dy */);
void ras_set_nchan(/* p, nchan */);
void ras_write_pixel(/* p, x, y, pv */);
void ras_write_pixel_rgba(/* p, x, y, r, g, b, a */);
void ras_write_row(/* p, y, x0, nx, buf */);
void ras_write_row_rgba(/* p, y, x0, nx, buf */);

#endif
