#ifndef DUMP_HDR
#define DUMP_HDR

/* $Header: dump.h,v 2.1 88/11/01 21:09:45 ph Locked $ */
#include <stdio.h>
#include <pixel.h>
#define DUMP_NAMEMAX 80

typedef struct {
    short magic;		/* magic number */
    short nchan;		/* number of channels (1=monochrome, 3=RGB) */
    short dx, dy;		/* width and height of picture in pixels */
} Dump_head;

typedef struct {
    char name[DUMP_NAMEMAX];	/* picture name */
    Dump_head h;		/* file header */
    FILE *fp;			/* stream for current file */
    int headsize;		/* size of head in bytes (for fseek) */
    int headwritten;		/* has header been written? */
    int curx, cury;		/* current x and y */
} Dump;

#define DUMP_MAGIC 0x5088	/* dump magic number */

Dump	*dump_open(/* file, mode */);
void	dump_close(/* p */);

char	*dump_get_name(/* p */);
void	dump_clear(/* p, pv */);
void	dump_clear_rgba(/* p, r, g, b, a */);

void	dump_set_nchan(/* p, nchan */);
void	dump_set_box(/* p, ox, oy, dx, dy */);
void	dump_write_pixel(/* p, x, y, pv */);
void	dump_write_pixel_rgba(/* p, x, y, r, g, b, a */);
void	dump_write_row(/* p, y, x0, nx, buf */);
void	dump_write_row_rgba(/* p, y, x0, nx, buf */);

int	dump_get_nchan(/* p */);
void	dump_get_box(/* p, ox, oy, dx, dy */);
Pixel1	dump_read_pixel(/* p, x, y */);
void	dump_read_pixel_rgba(/* p, x, y, pv */);
void	dump_read_row(/* p, y, x0, nx, buf */);
void	dump_read_row_rgba(/* p, y, x0, nx, buf */);

void dump_jump_to_pixel(/* p, x, y */);
void dump_advance(/* p, nx */);

#endif
