/*
 * dump: subroutine package to read and write my dump picture file format
 *
 * Paul Heckbert	1 Oct 1988
 */

static char rcsid[] = "$Header: dump.c,v 2.1 88/11/01 21:09:43 ph Locked $";

#include <simple.h>
#include "dump.h"

#ifdef vax		/* swap bytes in header if little-endian */
#   define BYTESWAP
#endif

#define UNDEF PIXEL_UNDEFINED

#define CHECK_HEAD_UNWRITTEN(p, subrname) {	\
    if ((p)->headwritten) {			\
	fprintf(stderr, "%s: can't change state once writing commences\n", \
	    subrname);				\
	exit(1);				\
    }						\
}
#define CHECK_HEAD_WRITTEN(p, subrname) \
    if (!(p)->headwritten) dump_write_head(p, subrname); else

Dump *dump_open_read(), *dump_open_write();

Dump *dump_open(file, mode)
char *file, *mode;
{
    if (str_eq(mode, "r")) return dump_open_read(file);
    if (str_eq(mode, "w")) return dump_open_write(file);
    fprintf(stderr, "dump_open: can't do mode %s\n", mode);
    exit(1); /*NOTREACHED*/
}

static Dump *dump_open_write(file)
char *file;
{
    Dump *p;

    ALLOC(p, Dump, 1);
    if ((p->fp = fopen(file, "w")) == NULL) {
	fprintf(stderr, "dump_open_write: can't write %s\n", file);
	free(p);
	return 0;
    }
    p->h.magic = DUMP_MAGIC;
    p->h.nchan = 3;
    p->h.dx = UNDEF;
    strcpy(p->name, file);
    p->headsize = sizeof(Dump_head);
    p->headwritten = 0;
    p->curx = p->cury = 0;
    return p;
}

static void dump_write_head(p, subrname)
Dump *p;
char *subrname;
{
    if (p->h.dx==UNDEF) {
	fprintf(stderr, "%s: size of %s is uninitialized\n", subrname, p->name);
	exit(1);
    }
#   ifdef BYTESWAP
	headswap(&p->h);
#   endif
    if (fwrite(&p->h, sizeof(Dump_head), 1, p->fp) != 1) {
	fprintf(stderr, "%s: write error on %s\n", subrname, p->name);
	exit(1);
    }
    printf("%s: %dx%d %d-chan\n", p->name, p->h.dx, p->h.dy, p->h.nchan);
    p->headwritten = 1;
}

static Dump *dump_open_read(file)
char *file;
{
    int badhead;
    Dump *p;

    ALLOC(p, Dump, 1);
    if ((p->fp = fopen(file, "r")) == NULL) {
	fprintf(stderr, "dump_open_read: can't find %s\n", file);
	free(p);
	return 0;
    }

    badhead = fread(&p->h, sizeof(Dump_head), 1, p->fp) != 1;
#   ifdef BYTESWAP
	headswap(&p->h);
#   endif
    if (badhead || p->h.magic!=DUMP_MAGIC) {
	fprintf(stderr, "dump_open_read: %s is not a dump file\n", file);
	free(p);
	return 0;
    }
    printf("%s: %dx%d %d-chan\n", file, p->h.dx, p->h.dy, p->h.nchan);
    strcpy(p->name, file);
    p->headsize = sizeof(Dump_head);
    p->headwritten = 1;
    p->curx = p->cury = 0;
    return p;
}

#ifdef BYTESWAP

static headswap(h)
Dump_head *h;
{
    swap_short(&h->magic);
    swap_short(&h->nchan);
    swap_short(&h->dx);
    swap_short(&h->dy);
}

#endif

void dump_close(p)
Dump *p;
{
    if (p->fp) fclose(p->fp);
    free(p);
}

char *dump_get_name(p)
Dump *p;
{
    return p->name;
}

void dump_clear(p, pv)
Dump *p;
Pixel1 pv;
{
    fprintf(stderr, "dump_clear: unimplemented\n");
}

void dump_clear_rgba(p, r, g, b, a)
Dump *p;
Pixel1 r, g, b, a;
{
    fprintf(stderr, "dump_clear_rgba: unimplemented\n");
}

/*-------------------- file writing routines --------------------*/

void dump_set_nchan(p, nchan)
Dump *p;
int nchan;
{
    CHECK_HEAD_UNWRITTEN(p, "dump_set_nchan");
    if (nchan!=1 && nchan!=3) {
	fprintf(stderr, "dump_set_nchan: can't handle nchan=%d\n", nchan);
	exit(1);
    }
    p->h.nchan = nchan;
}

void dump_set_box(p, ox, oy, dx, dy)
Dump *p;
int ox, oy, dx, dy;
{
    CHECK_HEAD_UNWRITTEN(p, "dump_set_box");
    /* ignore ox, oy */
    p->h.dx = dx;
    p->h.dy = dy;
}

void dump_write_pixel(p, x, y, pv)
Dump *p;
int x, y;
Pixel1 pv;
{
    fprintf(stderr, "dump_write_pixel: unimplemented\n");
}

void dump_write_pixel_rgba(p, x, y, r, g, b, a)
Dump *p;
int x, y;
Pixel1 r, g, b, a;
{
    fprintf(stderr, "dump_write_pixel_rgba: unimplemented\n");
}

void dump_write_row(p, y, x0, nx, buf)
register Dump *p;
int y, x0, nx;
Pixel1 *buf;
{
    CHECK_HEAD_WRITTEN(p, "dump_write_row");
    if (x0!=p->curx || y!=p->cury)
	dump_jump_to_pixel(p, x0, y);
    if (fwrite(buf, nx*sizeof(Pixel1), 1, p->fp) != 1) {
	fprintf(stderr, "dump_write_row: write error on %s\n", p->name);
	exit(1);
    }
    dump_advance(p, nx);
}

void dump_write_row_rgba(p, y, x0, nx, buf)
register Dump *p;
int y, x0, nx;
register Pixel1_rgba *buf;
{
    register int x;

    CHECK_HEAD_WRITTEN(p, "dump_write_row_rgba");
    if (x0!=p->curx || y!=p->cury)
	dump_jump_to_pixel(p, x0, y);
    for (x=nx; --x>=0; buf++) {
	putc(buf->r, p->fp);
	putc(buf->g, p->fp);
	putc(buf->b, p->fp);
    }
    dump_advance(p, nx);
}

/*-------------------- file reading routines --------------------*/

int dump_get_nchan(p)
Dump *p;
{
    return p->h.nchan;
}

void dump_get_box(p, ox, oy, dx, dy)
Dump *p;
int *ox, *oy, *dx, *dy;
{
    if (p->h.dx==UNDEF) {
	*ox = UNDEF;		/* used by some programs (e.g. zoom) */
	*oy = UNDEF;
    }
    else {
	*ox = 0;
	*oy = 0;
    }
    *dx = p->h.dx;
    *dy = p->h.dy;
}

Pixel1 dump_read_pixel(p, x, y)
Dump *p;
int x, y;
{
    fprintf(stderr, "dump_read_pixel: unimplemented\n");
}

void dump_read_pixel_rgba(p, x, y, pv)
Dump *p;
int x, y;
Pixel1_rgba *pv;
{
    fprintf(stderr, "dump_read_pixel_rgba: unimplemented\n");
}

void dump_read_row(p, y, x0, nx, buf)
register Dump *p;
int y, x0, nx;
Pixel1 *buf;
{
    if (x0!=p->curx || y!=p->cury)
	dump_jump_to_pixel(p, x0, y);
    if (fread(buf, nx*sizeof(Pixel1), 1, p->fp) != 1) {
	fprintf(stderr, "dump_read_row: read error on %s\n", p->name);
	exit(1);
    }
    dump_advance(p, nx);
}

void dump_read_row_rgba(p, y, x0, nx, buf)
register Dump *p;
int y, x0, nx;
register Pixel1_rgba *buf;
{
    register int x;

    if (x0!=p->curx || y!=p->cury)
	dump_jump_to_pixel(p, x0, y);
    for (x=nx; --x>=0; buf++) {
	buf->r = getc(p->fp);
	buf->g = getc(p->fp);
	buf->b = getc(p->fp);
	buf->a = PIXEL1_MAX;
    }
    dump_advance(p, nx);
}

void dump_jump_to_pixel(p, x, y)
Dump *p;
int x, y;
{
    /* fprintf(stderr, "jumping from (%d,%d) to (%d,%d) in %s\n", */
	/* p->curx, p->cury, x, y, p->name); */
    p->curx = x;
    p->cury = y;
    assert(fseek(p->fp, p->headsize+(y*p->h.dx+x)*p->h.nchan*sizeof(Pixel1), 0) == 0);
}

void dump_advance(p, nx)
register Dump *p;
int nx;
{
    p->curx += nx;
    if (p->curx >= p->h.dx) {
	p->curx -= p->h.dx;
	p->cury++;
    }
}
