/*
	File:			SGVec.cc

	Function:		See header file

	Author(s):		Andrew Willmott

	Copyright:		Copyright (c) 1995-1996, Andrew Willmott

	Notes:			

	Change History:
		31/01/96	ajw		Started
*/

#include "SGVec.h"
#include "Vec.h"
#include "CopyVec.h"


TMPLVec TSGVec::SGVec(Int n, TReal data[], Int span) : elts(n), span(span), data(data)
{
}

TMPLVec TSGVec::SGVec(TSGVec &v) : elts(v.elts), span(v.span), data(v.data)
{
}

TMPLVec TSGVec &TSGVec::operator = (const TSGVec &v)
{
	return(CopyVec((SELF), v));
}

TMPLVec TSGVec &TSGVec::operator = (const TVec &v)
{
	return(CopyVec((SELF), v));
}

TMPLVec TSGVec &TSGVec::operator >> (Action<TReal> &a)
{
	Int i;
	
	a.Start();
	
	for (i = 0; i < Elts(); i++)
		a.Process(SELF[i]);
	
	a.Stop();
	
	return(SELF);
}

