/*
	File:			SuffProto.h

	Function:		Provides definitions for suffixed typedefs of templated VL classes. E.g., 
					you can refer to Vec2<int> with Vec2i. See VLd.h for example usage.
					
	Author(s):		Andrew Willmott

	Copyright:		Copyright (c) 1995-1996, Andrew Willmott
 */

#ifndef VL_MV_PROTO
#define VL_MV_PROTO(TYPE)
#endif

#ifdef __Vec2__
VL_V_PROTO(Vec2);
VL_MV_PROTO(Vec2);
#endif

#ifdef __Vec3__
VL_V_PROTO(Vec3);
VL_MV_PROTO(Vec3);
#endif

#ifdef __Vec4__
VL_V_PROTO(Vec4);
VL_MV_PROTO(Vec4);
#endif

#ifdef __Mat2__
VL_M_PROTO(Mat2);
#endif

#ifdef __Mat3__
VL_M_PROTO(Mat3);
#endif

#ifdef __Mat4__
VL_M_PROTO(Mat4);
#endif

#ifdef __Vec__
VL_V_PROTO(Vec);
VL_M_PROTO(Mat);
#endif

#ifdef __SparseVec__
VL_V_PROTO(SparseVec);
VL_MV_PROTO(SparseVec);
VL_M_PROTO(SparseMat);
#endif

#undef VL_V_PROTO
#undef VL_MV_PROTO
#undef VL_M_PROTO
