/*
	File:			CopyVec.h

	Function:		Template for copying between different vector types.
					
	Author(s):		Andrew Willmott

	Copyright:		Copyright (c) 1995-1996, Andrew Willmott
 */

#ifndef __CopyVec__
#define __CopyVec__

template<class TA, class TB> TA &CopyVec(TA &a, const TB &b)
{
	Assert(a.Elts() == b.Elts(), "(CopyVec::=) Vector sizes don't match");
	
	Int i;
	
	for (i = 0; i < a.Elts(); i++)
		a[i] = b[i];

	return(a);
}

template<class TA, class TB> TA &NCCopyVec(TA &a, TB &b)
{
	Assert(a.Elts() == b.Elts(), "(CopyVec::=) Vector sizes don't match");
	
	Int i;
	
	for (i = 0; i < a.Elts(); i++)
		a[i] = b[i];

	return(a);
}

#endif
