/*
	File:			Action.h

	Function:		Defines an 'Action' which can be applied to all members of a container.
					
	Author(s):		Andrew Willmott

	Copyright:		Copyright (c) 1995-1996, Andrew Willmott
 */

#ifndef __Action__
#define __Action__

#include "Basics.h"

#define TAction Action<T>


// --- Abstract Action Class ---------------------------------------------------


template <class T> class Action
{
public: 
		
	virtual void	Start() {};
	virtual void 	Process(T &t) = 0;				// Abstract action method.
	virtual void	Stop() {};
};

#endif
