/*
 *  ui_form.C: The UI form definiton file, mostly generated by fdesign.
 *             Some elements added manually (e.g., the slider array).
 *
 *  Thomas Kang
 *
 *  October 26, 1996
 */


#include "forms.h"
#include <stdlib.h>
#include "ui_form.H"


FD_BRDFv *create_form_BRDFv(void)
{
  FL_OBJECT *obj;
  FD_BRDFv *fdui = (FD_BRDFv *) fl_calloc(1, sizeof(*fdui));

  fdui->BRDFv = fl_bgn_form(FL_NO_BOX, 960, 480);
  fdui->pane = obj = fl_add_box(FL_FRAME_BOX,10,10,430,460,"");
  obj = fl_add_box(FL_UP_BOX,0,0,960,480,"");

  // text labels
  obj = fl_add_text(FL_NORMAL_TEXT,460,10,130,20,"light vector");
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  obj = fl_add_text(FL_NORMAL_TEXT,460,240,130,20,"view control");
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  obj = fl_add_text(FL_NORMAL_TEXT,610,80,340,20,"model parameters");
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);

  // frames
  obj = fl_add_frame(FL_ENGRAVED_FRAME,460,30,130,190,"");
  obj = fl_add_frame(FL_ENGRAVED_FRAME,460,260,130,210,"");
  obj = fl_add_frame(FL_ENGRAVED_FRAME,610,100,340,290,"");
    fl_set_object_lalign(obj,FL_ALIGN_TOP);

  // general control buttons
  fdui->Scale = obj = fl_add_button(FL_PUSH_BUTTON,610,410,60,60,"Radiance");
    fl_set_object_callback(obj,radiance,0);
  fdui->reset = obj = fl_add_button(FL_NORMAL_BUTTON,680,410,90,60,"Reset");
    fl_set_object_callback(obj,reset,0);
  fdui->print = obj = fl_add_button(FL_NORMAL_BUTTON,770,410,90,60,"Print");
    fl_set_object_callback(obj,print,0);
  fdui->exit = obj = fl_add_button(FL_NORMAL_BUTTON,860,410,90,60,"Exit");

  // light vector controls
  fdui->CtrlLight = fl_bgn_group();
  fdui->RotTheta = obj = fl_add_valslider(FL_VERT_NICE_SLIDER,480,40,40,160,"theta");
    fl_set_object_callback(obj,orient,0);
    fl_set_slider_bounds(obj, 89.99, 0.00);
    fl_set_slider_value(obj, 0.00);
     fl_set_slider_return(obj, FL_RETURN_CHANGED);
  fdui->RotPhi = obj = fl_add_valslider(FL_VERT_NICE_SLIDER,532,40,38,160,"phi");
    fl_set_object_callback(obj,orient,0);
    fl_set_slider_bounds(obj, 360.00, 0.00);
    fl_set_slider_value(obj, 0.00);
    fl_set_slider_return(obj, FL_RETURN_CHANGED);
  fl_end_group();

  // view controls
  fdui->CtrlView = fl_bgn_group();
  fdui->RotX = obj = fl_add_valslider(FL_VERT_NICE_SLIDER,470,270,37,180,"x");
    fl_set_object_callback(obj,orient,0);
    fl_set_slider_bounds(obj, 360.00, 0.00);
    fl_set_slider_value(obj, 0.00);
    fl_set_slider_return(obj, FL_RETURN_CHANGED);
  fdui->RotY = obj = fl_add_valslider(FL_VERT_NICE_SLIDER,507,270,36,180,"y");
    fl_set_object_callback(obj,orient,0);
    fl_set_slider_bounds(obj, 360.00, 0.00);
    fl_set_slider_value(obj, 0.00);
    fl_set_slider_return(obj, FL_RETURN_CHANGED);
  fdui->RotZ = obj = fl_add_valslider(FL_VERT_NICE_SLIDER,543,270,37,180,"z");
    fl_set_object_callback(obj,orient,0);
    fl_set_slider_bounds(obj, 360.00, 0.00);
    fl_set_slider_value(obj, 0.00);
    fl_set_slider_return(obj, FL_RETURN_CHANGED);
  fl_end_group();

  // reflectance model chooser
  fdui->ReflModel = obj = fl_add_choice(FL_NORMAL_CHOICE,610,30,340,30,"reflectance model");
    fl_set_object_boxtype(obj,FL_SHADOW_BOX);
    fl_set_object_lalign(obj,FL_ALIGN_TOP_LEFT);
    fl_set_object_resize(obj, FL_RESIZE_NONE);
    fl_set_object_callback(obj,choose_model,0);

  // reflectance model parameter controls
  fdui->CtrlModel = fl_bgn_group();
  for (int i = 0; i < NUM_SLIDERS; i++) {
    obj = fl_add_valslider(FL_VERT_NICE_SLIDER,620+(40*i),110,40,260,"");
    fdui->slider[i] = obj;
    fl_set_object_callback(obj,manipulate,0);
    fl_set_slider_return(obj, FL_RETURN_CHANGED);
  }
  fl_end_group();

  fl_end_form();

  return fdui;
}
/*---------------------------------------*/
