// illum: illumination model base class
// Derive particular illumination models from this.
//
// An instance of a class derived from Illum is a BRDF with particular
// parameter settings (diffuse coefficient, roughness, etc).
//
// Paul Heckbert	22 Oct 1996

#ifndef _ILLUM
#define _ILLUM

#include <iostream.h>
#include <VLd.h>

class Param {			// parameter name and value
  public:
    char *name;			// parameter name (for slider labels, etc)
    double val;			// parameter value
    double min, max;		// minimum reasonable values

    void reset(char *_name, double _val, double _min, double _max)
	{name = _name; val = _val; min = _min; max = _max;}
};

const param_max = 12;
    // maximum number of parameters to illumination model

class Illum {			// illumination model base class
  public:
    char *iname;		// name of illumination model
    int nparam;			// number of parameters (<=param_max)
    Param param[param_max];	// array of parameters

    virtual void reset()	// reset parameters to default values
	= 0;

    virtual Vec3 brdf(const Vec3 &n, const Vec3 &i, const Vec3 &o) const
	= 0;
	// what is BRDF for normal n, incoming direction (light direction) i,
	// outgoing direction (viewer direction) o, evaluated at red,
	// green and blue wavelengths?  Returns an RGB reflectance vector.

	// IMPORTANT: All three of these direction vectors are assumed
	// to be unit length.
	// This routine only supports isotropic BRDF's.

    virtual void print(ostream &s) const        // print current settings
	= 0;
};

ostream &operator<<(ostream &s, const Illum &ill); // print an Illum

// clean up a few things in the vector library VL
#ifdef dot

#undef dot	// I don't like VL's '#define dot %'

inline double dot(const Vec3 &a, const Vec3 &b) {	// dot product
    return a%b;
    // return a[0]*b[0] + a[1]*b[1] + a[2]*b[2];
}

inline Vec3 component_mul(const Vec3 &a, const Vec3 &b) { // component-wise mul
    return a*b;
}

#endif

#endif
