/* glxf.h: header file for opengl/xforms utilities */

#ifndef GLXF_H
#define GLXF_H

#include <GL/gl.h>
#include <GL/glx.h>
#include <forms.h>

typedef struct {
    void (*handle_event)(XEvent *event);
	/* event handler to handle mouse, keyboard, expose events for pane */

    Display *display;		/* display for pane */
    Window window;		/* window number for pane */
    GLXContext context;		/* context for pane */
    int width, height;		/* width and height of pane */
} Glxf_pane;

void glxf_bind_pane(Glxf_pane *pane, FL_OBJECT *object, int double_buf,
    void (*handle_event)(XEvent *event));


#endif
