// SimpleImageView.cpp : implementation file
//

#include "stdafx.h"
#include "SimpleImageView.h"
#include "resource.h"

#include <Image.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSimpleImageView

IMPLEMENT_DYNCREATE(CSimpleImageView, CScrollView)

CSimpleImageView::CSimpleImageView()
: m_szImage(100, 100), m_hbmpImage(NULL)
{
	SetScrollSizes(MM_TEXT, m_szImage);
}

CSimpleImageView::~CSimpleImageView()
{
}


BEGIN_MESSAGE_MAP(CSimpleImageView, CScrollView)
	//{{AFX_MSG_MAP(CSimpleImageView)
	ON_WM_RBUTTONUP()
	ON_COMMAND(ID_SIMAGE_SAVE, OnSimageSave)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSimpleImageView drawing

void CSimpleImageView::OnInitialUpdate()
{
	CScrollView::OnInitialUpdate();

	CSize sizeTotal;
	// TODO: calculate the total size of this view
	SetScrollSizes(MM_TEXT, m_szImage);
}

void CSimpleImageView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: add draw code here
	if(m_hbmpImage)
	{
		CDC memdc;
		memdc.CreateCompatibleDC(pDC);
		memdc.SelectObject(m_hbmpImage);
		pDC->BitBlt(0,0, m_szImage.cx, m_szImage.cy, &memdc, 0, 0, SRCCOPY); 
	}
}

/////////////////////////////////////////////////////////////////////////////
// CSimpleImageView diagnostics

#ifdef _DEBUG
void CSimpleImageView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CSimpleImageView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSimpleImageView message handlers

void CSimpleImageView::SetImage(IImage *pimg)
{
	PixelFormat pf;
	pf.dwSize = sizeof(PixelFormat);
	if(m_hbmpImage)
		::DeleteObject(m_hbmpImage);
	DWORD dwCX, dwCY;
	pimg->GetSize(&dwCX, &dwCY);
	pimg->GetFormat(&pf);
	m_szImage = CSize(dwCX, dwCY);
	BITMAPINFO bi;
	RGBQUAD* prgbqPixels;
	void* ppixSrc;
	HDC hdc = ::GetDC(::GetDesktopWindow());
	bi.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	bi.bmiHeader.biWidth = dwCX;
	bi.bmiHeader.biHeight = -(int)dwCY;
	bi.bmiHeader.biPlanes = 1;
	bi.bmiHeader.biBitCount = 32;
	bi.bmiHeader.biCompression = BI_RGB;
	bi.bmiHeader.biSizeImage = 0;
	bi.bmiHeader.biXPelsPerMeter = 640;
	bi.bmiHeader.biYPelsPerMeter = 640;
	bi.bmiHeader.biClrUsed = 0;
	bi.bmiHeader.biClrImportant = 0;
	m_hbmpImage = ::CreateDIBSection(hdc, &bi, DIB_RGB_COLORS, (void**)&prgbqPixels, NULL, 0);
	if(!m_hbmpImage)
		return;
	::ReleaseDC(::GetDesktopWindow(), hdc);
	pimg->LockImage(&ppixSrc);
	RGBQUAD* pDest = prgbqPixels + (dwCX * dwCY);
	DWORD i, j;
	switch(pf.dwTypeFlags)
	{
	case PF_FLOAT | PF_LONG:
		{
			double * pdSrc = (double*)ppixSrc;
			if(pf.bChannels == 1)
			{
				for(j=0; j < dwCY; j++)
				{
					pDest -= dwCX;
					for(i=0; i < dwCX; i++, pdSrc++, pDest++)
					{
						pDest->rgbRed = (BYTE)(255.0 * pdSrc[0]);
						pDest->rgbGreen = (BYTE)(255.0 * pdSrc[0]);
						pDest->rgbBlue = (BYTE)(255.0 * pdSrc[0]);
						pDest->rgbReserved  = 0x00;
					}
					pDest -= dwCX;
				}
			}
			else
			{
				for(j=0; j < dwCY; j++)
				{
					pDest -= dwCX;
					for(i=0; i < dwCX; i++, pdSrc+=4, pDest++)
					{
						pDest->rgbRed = (BYTE)(255.0 * pdSrc[0]);
						pDest->rgbGreen = (BYTE)(255.0 * pdSrc[1]);
						pDest->rgbBlue = (BYTE)(255.0 * pdSrc[2]);
						pDest->rgbReserved  = 0x00;
					}
					pDest -= dwCX;
				}
			}
		} break;
	case PF_INT | PF_BYTE :
		{
			BYTE * pbSrc = (BYTE*)ppixSrc;
			if(pf.bChannels == 1)
			{
				for(j=0; j < dwCY; j++)
				{
					pDest -= dwCX;
					for(i=0; i < dwCX; i++, pbSrc++, pDest++)
					{
						pDest->rgbRed = pbSrc[0];
						pDest->rgbGreen = pbSrc[0];
						pDest->rgbBlue = pbSrc[0];
						pDest->rgbReserved  = 0x00;
					}
					pDest -= dwCX;
				}
			}
			else
			{
				for(j=0; j < dwCY; j++)
				{
					pDest -= dwCX;
					for(i=0; i < dwCX; i++, pbSrc+=4, pDest++)
					{
						pDest->rgbRed = pbSrc[0];
						pDest->rgbGreen = pbSrc[1];
						pDest->rgbBlue = pbSrc[2];
						pDest->rgbReserved  = 0x00;
					}
					pDest -= dwCX;
				}
			}
		} break;
	}
	pimg->UnlockImage(ppixSrc);
	SetScrollSizes(MM_TEXT, m_szImage);
}

void CSimpleImageView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	// TODO: Add your specialized code here and/or call the base class
	if(lHint == TEXTOR_UPDATE_REP)
	{
		SetImage(reinterpret_cast<IImage*>(pHint));
	}
	
}

void CSimpleImageView::OnRButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	ClientToScreen(&point);
	CMenu menu;
	menu.LoadMenu(IDR_SIMAGE);
	menu.GetSubMenu(0)->TrackPopupMenu(TPM_LEFTALIGN, point.x, point.y, this);
	CScrollView::OnRButtonUp(nFlags, point);
}

void CSimpleImageView::OnSimageSave() 
{
	// TODO: Add your command handler code here
	if(!m_hbmpImage)
		return;
	CFileDialog dlg(FALSE, ".BMP", NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, "Bitmap Image (*.BMP)|*.BMP||", this);
	if(dlg.DoModal() == IDOK)
	{
		SaveBitmap(m_hbmpImage, dlg.GetPathName());
	}

}

BOOL CSimpleImageView::SaveBitmap(HBITMAP hbmp, LPCTSTR lpszFilename)
{
	PICTDESC pd;
	HRESULT hr;
	memset(&pd, 0, sizeof(PICTDESC));
	pd.cbSizeofstruct = sizeof(PICTDESC);
	pd.picType = PICTYPE_BITMAP;
	pd.bmp.hbitmap = hbmp;
	IPersistStream* pPic;
	IStream* pstm;
	hr = ::OleCreatePictureIndirect(&pd, IID_IPersistStream, FALSE, (void**)&pPic);
	if(FAILED(hr))
	{
		return FALSE;
	}
	hr = ::CreateStreamOnHGlobal(NULL, TRUE, &pstm);
	if(FAILED(hr))
	{
		pPic->Release();
	}
	hr = pPic->Save(pstm, FALSE);
	pPic->Release();
	if(FAILED(hr))
	{
		pstm->Release();
		return FALSE;
	}
	STATSTG stat;
	pstm->Stat(&stat, STATFLAG_NONAME);
	HGLOBAL hg;
	GetHGlobalFromStream(pstm, &hg);
	HANDLE hfile;
	hfile = ::CreateFile(lpszFilename, GENERIC_WRITE, FILE_SHARE_READ, NULL, 
		CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
	if(hfile)
	{
		BYTE* p = (BYTE*)GlobalLock(hg);
		p += 8; //some header crap
		DWORD dw;
		if(!::WriteFile(hfile, p, stat.cbSize.LowPart, &dw, NULL))
			hr = HRESULT_FROM_WIN32(GetLastError());
		GlobalUnlock(hg);
		CloseHandle(hfile);
	}
	else
		hr = HRESULT_FROM_WIN32(GetLastError());
	pstm->Release();
	return FALSE;

}
