// SimpleImageCtrl.cpp : implementation file
//

#include "stdafx.h"
#include "SimpleImageCtrl.h"
#include <bitmap.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSimpleImageCtrl

CSimpleImageCtrl::CSimpleImageCtrl()
: m_pimg(NULL), m_hbmpImage(NULL), m_szImage(0,0)
{
}

CSimpleImageCtrl::~CSimpleImageCtrl()
{
	if(m_pimg)
		m_pimg->Release();
	if(m_hbmpImage)
		::DeleteObject(m_hbmpImage);
}


BEGIN_MESSAGE_MAP(CSimpleImageCtrl, CWnd)
	//{{AFX_MSG_MAP(CSimpleImageCtrl)
	ON_WM_PAINT()
	ON_WM_VSCROLL()
	ON_WM_SIZE()
	ON_WM_HSCROLL()
	ON_WM_NCLBUTTONDOWN()
	ON_WM_NCLBUTTONUP()
	ON_WM_NCMOUSEMOVE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CSimpleImageCtrl::SetImage(IImage* pimg)
{
	if(!pimg)
		return;
	if(m_pimg)
		m_pimg->Release();
	m_pimg = NULL;
	if(m_hbmpImage)
		::DeleteObject(m_hbmpImage);
	SIZE sz;
	m_hbmpImage = ::CreateBitmap(pimg, sz);
	if(!m_hbmpImage)
		return;
	m_pimg = pimg;
	m_pimg->AddRef();
	m_szImage = sz;
	SCROLLINFO si;
	CRect rClient;
	GetClientRect(&rClient);
	si.cbSize = sizeof(SCROLLINFO);
	si.fMask = SIF_ALL;
	si.nMax = sz.cx;
	si.nMin = 0;
	si.nPage = rClient.Width();
	si.nPos = 0;
	si.nTrackPos = 0;
	SetScrollInfo(SB_HORZ, &si, FALSE);
	si.nMax = sz.cy;
	si.nPage = rClient.Height();

	SetScrollInfo(SB_VERT, &si, TRUE);
	EnableScrollBar(SB_BOTH);
	ShowScrollBar(SB_BOTH);
}

void CSimpleImageCtrl::UpdateImage()
{
	if(!m_pimg)
		return;
	if(m_hbmpImage)
		::DeleteObject(m_hbmpImage);
	SIZE sz;
	m_hbmpImage = ::CreateBitmap(m_pimg, sz);
	RedrawWindow();
}

void CSimpleImageCtrl::GetImage(IImage** ppimg)
{
	if(!ppimg)
		return;
	*ppimg = m_pimg;
	if(m_pimg)
		m_pimg->AddRef();
}


/////////////////////////////////////////////////////////////////////////////
// CSimpleImageCtrl message handlers

void CSimpleImageCtrl::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	CRect r;
	GetClientRect(&r);

	// TODO: Add your message handler code here
	if(m_hbmpImage)
	{
		CDC memdc;
		memdc.CreateCompatibleDC(&dc);
		memdc.SelectObject(m_hbmpImage);
		dc.BitBlt(0, 0, min(m_szImage.cx, r.Width()), min(m_szImage.cy, r.Height()), &memdc, 0, 0, SRCCOPY);
	}
	// Do not call CWnd::OnPaint() for painting messages
}

void CSimpleImageCtrl::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: Add your message handler code here and/or call default
	
	CWnd::OnVScroll(nSBCode, nPos, pScrollBar);
}

void CSimpleImageCtrl::OnSize(UINT nType, int cx, int cy) 
{
	CWnd::OnSize(nType, cx, cy);
	
	// TODO: Add your message handler code here
	
}

void CSimpleImageCtrl::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: Add your message handler code here and/or call default
	
	CWnd::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CSimpleImageCtrl::OnNcLButtonDown(UINT nHitTest, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	CWnd::OnNcLButtonDown(nHitTest, point);
}

void CSimpleImageCtrl::OnNcLButtonUp(UINT nHitTest, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	CWnd::OnNcLButtonUp(nHitTest, point);
}

void CSimpleImageCtrl::OnNcMouseMove(UINT nHitTest, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	CWnd::OnNcMouseMove(nHitTest, point);
}
