// MaskedImageView.h: interface for the CMaskedImageView class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MASKEDIMAGEVIEW_H__E172BB51_992A_11D3_80A2_0050DA2B1C95__INCLUDED_)
#define AFX_MASKEDIMAGEVIEW_H__E172BB51_992A_11D3_80A2_0050DA2B1C95__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "SimpleImageView.h"

class CMaskedImageView : public CSimpleImageView  
{
protected:
	DECLARE_DYNCREATE(CMaskedImageView)

public:
	CMaskedImageView();
	virtual ~CMaskedImageView();

	void SetMaskImage(IImage* pimgMask);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMaskedImageView)
	protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
	virtual void OnInitialUpdate();     // first time after construct
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	//}}AFX_VIRTUAL



protected:
	HBITMAP m_hbmpMask;

	static void MaskToBMP(IImage* pimgMask, HBITMAP& hbmp);

	// Generated message map functions
	//{{AFX_MSG(CMaskedImageView)
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMimageSave();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

#endif // !defined(AFX_MASKEDIMAGEVIEW_H__E172BB51_992A_11D3_80A2_0050DA2B1C95__INCLUDED_)
