// MaskedImageView.cpp: implementation of the CMaskedImageView class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "MaskedImageView.h"
#include "resource.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

IMPLEMENT_DYNCREATE(CMaskedImageView, CSimpleImageView)

BEGIN_MESSAGE_MAP(CMaskedImageView, CSimpleImageView)
	//{{AFX_MSG_MAP(CMaskedImageView)
	ON_WM_RBUTTONUP()
	ON_COMMAND(ID_MIMAGE_SAVE, OnMimageSave)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


CMaskedImageView::CMaskedImageView()
: CSimpleImageView(), m_hbmpMask(NULL)
{

}

CMaskedImageView::~CMaskedImageView()
{
	if(m_hbmpMask)
		::DeleteObject(m_hbmpMask);
}

void CMaskedImageView::SetMaskImage(IImage* pimgMask)
{
	if(m_hbmpMask)
		::DeleteObject(m_hbmpMask);
	if(pimgMask)
		MaskToBMP(pimgMask, m_hbmpMask);
	else
		m_hbmpMask = NULL;
	RedrawWindow();
}

void CMaskedImageView::MaskToBMP(IImage* pimgMask, HBITMAP& hbmp)
{
	static RGBQUAD white = {0xFF, 0xFF, 0xFF, 0x00};
	static RGBQUAD black = {0x00, 0x00, 0x00, 0x00};
	PixelFormat pf;
	pf.dwSize = sizeof(PixelFormat);
	DWORD dwCX, dwCY;
	pimgMask->GetSize(&dwCX, &dwCY);
	pimgMask->GetFormat(&pf);

	BITMAPINFO bi;
	RGBQUAD* prgbqPixels;
	void* ppixSrc;
	HDC hdc = ::GetDC(::GetDesktopWindow());
	bi.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	bi.bmiHeader.biWidth = dwCX;
	bi.bmiHeader.biHeight = -(int)dwCY;
	bi.bmiHeader.biPlanes = 1;
	bi.bmiHeader.biBitCount = 32;
	bi.bmiHeader.biCompression = BI_RGB;
	bi.bmiHeader.biSizeImage = 0;
	bi.bmiHeader.biXPelsPerMeter = 640;
	bi.bmiHeader.biYPelsPerMeter = 640;
	bi.bmiHeader.biClrUsed = 0;
	bi.bmiHeader.biClrImportant = 0;
	hbmp = ::CreateDIBSection(hdc, &bi, DIB_RGB_COLORS, (void**)&prgbqPixels, NULL, 0);
	if(!hbmp)
		return;
	::ReleaseDC(::GetDesktopWindow(), hdc);
	pimgMask->LockImage(&ppixSrc);
	RGBQUAD* pDest = prgbqPixels + (dwCX * dwCY);
	DWORD i, j;
	switch(pf.dwTypeFlags)
	{
	case PF_INT | PF_BYTE :
		{
			BYTE * pbSrc = (BYTE*)ppixSrc;
			for(j=0; j < dwCY; j++)
			{
				pDest -= dwCX;
				for(i=0; i < dwCX; i++, pbSrc++, pDest++)
				{
					if(*pbSrc)
					{
						*pDest = white;
					}
					else
					{
						*pDest = black;
					}
				}
				pDest -= dwCX;
			}
		} break;
	}
	pimgMask->UnlockImage(ppixSrc);
}

void CMaskedImageView::OnDraw(CDC* pDC)      // overridden to draw this view
{
	if(m_hbmpImage)
	{
		CDC memdc;
		memdc.CreateCompatibleDC(pDC);
		memdc.SelectObject(m_hbmpImage);
		pDC->BitBlt(0,0, m_szImage.cx, m_szImage.cy, &memdc, 0, 0, SRCCOPY);
		if(m_hbmpMask)
		{
			CDC maskdc;
			maskdc.CreateCompatibleDC(pDC);
			maskdc.SelectObject(m_hbmpMask);
			pDC->BitBlt(0, 0, m_szImage.cx, m_szImage.cy, &maskdc, 0, 0, SRCAND);
		}
	}
}

void CMaskedImageView::OnInitialUpdate()     // first time after construct
{
	CSimpleImageView::OnInitialUpdate();
}

void CMaskedImageView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint)
{
	CSimpleImageView::OnUpdate(pSender, lHint, pHint);
}

void CMaskedImageView::OnRButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	ClientToScreen(&point);
	CMenu menu;
	menu.LoadMenu(IDR_MIMAGE);
	menu.GetSubMenu(0)->TrackPopupMenu(TPM_LEFTALIGN, point.x, point.y, this);
	CScrollView::OnRButtonUp(nFlags, point);
}

void CMaskedImageView::OnMimageSave() 
{
	// TODO: Add your command handler code here
	if(!m_hbmpImage)
		return;
	CFileDialog dlg(FALSE, ".BMP", NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, "Bitmap Image (*.BMP)|*.BMP||", this);
	if(dlg.DoModal() == IDOK)
	{
		SaveBitmap(m_hbmpMask, dlg.GetPathName());
	}

}
