// ErrorImageView.cpp : implementation file
//

#include "stdafx.h"
#include "SimpleImageView.h"
#include "ErrorImageView.h"
#include <imgproc.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CErrorImageView

IMPLEMENT_DYNCREATE(CErrorImageView, CSimpleImageView)

CErrorImageView::CErrorImageView()
: m_nThreshold(0.0), m_pimgError(NULL), m_pimgMask(NULL), m_hbmpMask(NULL)
{
}

CErrorImageView::~CErrorImageView()
{
	if(m_pimgError)
		m_pimgError->Release();
	if(m_pimgMask)
		m_pimgMask->Release();
	if(m_hbmpMask)
		::DeleteObject(m_hbmpMask);
}


BEGIN_MESSAGE_MAP(CErrorImageView, CSimpleImageView)
	//{{AFX_MSG_MAP(CErrorImageView)
	ON_WM_CHAR()
	ON_WM_KEYDOWN()
	ON_WM_LBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CErrorImageView drawing

void CErrorImageView::OnInitialUpdate()
{
	CSimpleImageView::OnInitialUpdate();

}

void CErrorImageView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: add draw code here
	CSimpleImageView::OnDraw(pDC);
	if(m_hbmpMask)
	{
		CDC memdc;
		memdc.CreateCompatibleDC(pDC);
		memdc.SelectObject(m_hbmpMask);
		CSize sz = GetTotalSize();
		pDC->BitBlt(0, 0, sz.cx, sz.cy, &memdc, 0, 0, SRCPAINT);
	}
}

/////////////////////////////////////////////////////////////////////////////
// CErrorImageView diagnostics

#ifdef _DEBUG
void CErrorImageView::AssertValid() const
{
	CSimpleImageView::AssertValid();
}

void CErrorImageView::Dump(CDumpContext& dc) const
{
	CSimpleImageView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CErrorImageView message handlers

void CErrorImageView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
	static double increment = 1.0 / 255.0;
	switch(nChar)
	{
	case VK_LEFT :
		{
			SetThreshold(m_nThreshold - increment);
		} break;
	case VK_RIGHT :
		{
			SetThreshold(m_nThreshold + increment);
		} break;
	}
	CSimpleImageView::OnChar(nChar, nRepCnt, nFlags);
}

void CErrorImageView::SetThreshold(double nNewThreshold)
{
	static RGBQUAD rgbq;
	rgbq.rgbBlue = 0x00;
	rgbq.rgbGreen = 0x00;
	rgbq.rgbRed = 0x5A;
	rgbq.rgbReserved = 0x00;
	m_nThreshold = nNewThreshold;
	if(m_pimgMask)
		m_pimgMask->Release();
	HRESULT hr = CoThresholdError(m_pimgError, m_nThreshold, GetHeapImageFactory(), &m_pimgMask);
	if(FAILED(hr))
		return;
	if(m_hbmpMask)
		::DeleteObject(m_hbmpMask);
	m_hbmpMask = CreateMaskBitmap(m_pimgMask, rgbq);
	RedrawWindow();
}

void CErrorImageView::SetImage(IImage *pimg)
{
	if(m_pimgError)
		m_pimgError->Release();
	m_pimgError = pimg;
	if(pimg)
		m_pimgError->AddRef();
	CSimpleImageView::SetImage(pimg);
}

HBITMAP CErrorImageView::CreateMaskBitmap(IImage *pimg, RGBQUAD &rgbqMask)
{
	static RGBQUAD white;
	white.rgbBlue = 0x00;
	white.rgbGreen = 0x00;
	white.rgbRed = 0x00;
	white.rgbReserved = 0x00;
	DWORD dwCX, dwCY;
	PixelFormat pf;
	pf.dwSize = sizeof(PixelFormat);
	pimg->GetSize(&dwCX, &dwCY);
	pimg->GetFormat(&pf);
	BITMAPINFO bi;
	RGBQUAD* prgbqPixels;
	void* ppixSrc;
	HDC hdc = ::GetDC(::GetDesktopWindow());
	bi.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	bi.bmiHeader.biWidth = dwCX;
	bi.bmiHeader.biHeight = -(int)dwCY;
	bi.bmiHeader.biPlanes = 1;
	bi.bmiHeader.biBitCount = 32;
	bi.bmiHeader.biCompression = BI_RGB;
	bi.bmiHeader.biSizeImage = 0;
	bi.bmiHeader.biXPelsPerMeter = 640;
	bi.bmiHeader.biYPelsPerMeter = 640;
	bi.bmiHeader.biClrUsed = 0;
	bi.bmiHeader.biClrImportant = 0;
	HBITMAP hbm = ::CreateDIBSection(hdc, &bi, DIB_RGB_COLORS, (void**)&prgbqPixels, NULL, 0);
	if(!hbm)
		return NULL;
	::ReleaseDC(::GetDesktopWindow(), hdc);
	pimg->LockImage(&ppixSrc);
	RGBQUAD* pDest = prgbqPixels + (dwCX * dwCY);
	DWORD i, j;
	switch(pf.dwTypeFlags)
	{
	case PF_FLOAT | PF_LONG:
		{
			double * pdSrc = (double*)ppixSrc;
			if(pf.bChannels == 1)
			{
				for(j=0; j < dwCY; j++)
				{
					pDest -= dwCX;
					for(i=0; i < dwCX; i++, pdSrc++, pDest++)
					{
						pDest->rgbRed = (BYTE)(255.0 * pdSrc[0]);
						pDest->rgbGreen = (BYTE)(255.0 * pdSrc[0]);
						pDest->rgbBlue = (BYTE)(255.0 * pdSrc[0]);
						pDest->rgbReserved  = 0x00;
					}
					pDest -= dwCX;
				}
			}
			else
			{
				for(j=0; j < dwCY; j++)
				{
					pDest -= dwCX;
					for(i=0; i < dwCX; i++, pdSrc+=4, pDest++)
					{
						pDest->rgbRed = (BYTE)(255.0 * pdSrc[0]);
						pDest->rgbGreen = (BYTE)(255.0 * pdSrc[1]);
						pDest->rgbBlue = (BYTE)(255.0 * pdSrc[2]);
						pDest->rgbReserved  = 0x00;
					}
					pDest -= dwCX;
				}
			}
		} break;
	case PF_INT | PF_BYTE :
		{
			BYTE * pbSrc = (BYTE*)ppixSrc;
			if(pf.bChannels == 1)
			{
				for(j=0; j < dwCY; j++)
				{
					pDest -= dwCX;
					for(i=0; i < dwCX; i++, pbSrc++, pDest++)
					{
						if(*pbSrc)
							*pDest = white;
						else
							*pDest = rgbqMask;
					}
					pDest -= dwCX;
				}
			}
			else
			{
				for(j=0; j < dwCY; j++)
				{
					pDest -= dwCX;
					for(i=0; i < dwCX; i++, pbSrc+=4, pDest++)
					{
						pDest->rgbRed = pbSrc[0];
						pDest->rgbGreen = pbSrc[1];
						pDest->rgbBlue = pbSrc[2];
						pDest->rgbReserved  = 0x00;
					}
					pDest -= dwCX;
				}
			}
		} break;
	}
	pimg->UnlockImage(ppixSrc);
	return hbm;
}

void CErrorImageView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
	
	CSimpleImageView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CErrorImageView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	if(!m_pimgError)
	{
		MessageBeep(MB_OK);
		return;
	}
	point.x += GetScrollPosition().x;
	point.y += GetScrollPosition().y;
	point.y = GetTotalSize().cy - point.y;
	DWORD dwCX, dwCY;
	m_pimgError->GetSize(&dwCX, &dwCY);
	void* ppix;
	m_pimgError->LockImage(&ppix);
	double* pSrc = (double*)ppix;
	pSrc += point.y * dwCX + point.x;
	double d = *pSrc;
	m_pimgError->UnlockImage(ppix);
	SetThreshold(d);
	CSimpleImageView::OnLButtonDown(nFlags, point);
}
