// texexView.cpp : implementation of the CTexexView class
//

#include "stdafx.h"
#include "texex.h"

#include "texexDoc.h"
#include "texexView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTexexView

IMPLEMENT_DYNCREATE(CTexexView, CScrollView)

BEGIN_MESSAGE_MAP(CTexexView, CScrollView)
	//{{AFX_MSG_MAP(CTexexView)
	ON_WM_LBUTTONDOWN()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CSimpleImageView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CSimpleImageView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CSimpleImageView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTexexView construction/destruction

CTexexView::CTexexView()
{
	// TODO: add construction code here

}

CTexexView::~CTexexView()
{
}

BOOL CTexexView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CSimpleImageView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CTexexView drawing

void CTexexView::OnDraw(CDC* pDC)
{
	CSimpleImageView::OnDraw(pDC);
	CTexexDoc* pDoc = GetDocument();
	pDoc->m_trkTexture.m_rect -= GetScrollPosition();
	pDoc->m_trkTexture.Draw(pDC);
	pDoc->m_trkTexture.m_rect += GetScrollPosition();
	ASSERT_VALID(pDoc);
	// TODO: add draw code for native data here
}

void CTexexView::OnInitialUpdate()
{
	SetImage(GetDocument()->m_pimgSrc);
	CSimpleImageView::OnInitialUpdate();
}

/////////////////////////////////////////////////////////////////////////////
// CTexexView printing

BOOL CTexexView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CTexexView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CTexexView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CTexexView diagnostics

#ifdef _DEBUG
void CTexexView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CTexexView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}

CTexexDoc* CTexexView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CTexexDoc)));
	return (CTexexDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CTexexView message handlers

void CTexexView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	GetDocument()->m_trkTexture.m_rect -= GetScrollPosition();
	if(GetDocument()->m_trkTexture.HitTest(point) != -1)
		GetDocument()->m_trkTexture.Track(this, point);
	else
	{
		GetDocument()->m_trkTexture.TrackRubberBand(this, point);
		GetDocument()->m_trkTexture.m_nStyle = CRectTracker::dottedLine | CRectTracker::resizeOutside;
	}
	GetDocument()->m_trkTexture.m_rect += GetScrollPosition();
	RedrawWindow();
	CScrollView::OnLButtonDown(nFlags, point);
}
