// texexDoc.h : interface of the CTexexDoc class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_TEXEXDOC_H__48CDAE51_8F02_11D3_809C_0050DA2B1C95__INCLUDED_)
#define AFX_TEXEXDOC_H__48CDAE51_8F02_11D3_809C_0050DA2B1C95__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <Image.h>
#include <texsyn.h>

class CTexexDoc : public CDocument
{
protected: // create from serialization only
	CTexexDoc();
	DECLARE_DYNCREATE(CTexexDoc)

// Attributes
public:
	IImage* m_pimgSrc;
	IImage* m_pimgTestedMask;
	IImage* m_pimgGlobalError;
	IImage* m_pimgGlobalMask;
	IImage* m_pimgLocalMask;
	IImage* m_pimgErrorFlowX;
	IImage* m_pimgErrorFlowY;
	IImage* m_pimgAlphaMask;
	double m_nGlobalThreshold;
	CRectTracker m_trkTexture;
	int m_nWindowSize;

// Operations
public:
	int StepImage();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CTexexDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual BOOL OnSaveDocument(LPCTSTR lpszPathName);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CTexexDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	CTexWindowIterator* m_pTexIter;

// Generated message map functions
protected:
	//{{AFX_MSG(CTexexDoc)
	afx_msg void OnFileResult1();
	afx_msg void OnUpdateFileResult1(CCmdUI* pCmdUI);
	afx_msg void OnFileResult2();
	afx_msg void OnUpdateFileResult2(CCmdUI* pCmdUI);
	afx_msg void OnFileResult3();
	afx_msg void OnUpdateFileResult3(CCmdUI* pCmdUI);
	afx_msg void OnImageGo();
	afx_msg void OnUpdateImageGo(CCmdUI* pCmdUI);
	afx_msg void OnImageStart();
	afx_msg void OnImageStep();
	afx_msg void OnImageParameters();
	afx_msg void OnImageRefine();
	afx_msg void OnImageAntialias();
	afx_msg void OnFileResult4();
	afx_msg void OnUpdateFileResult4(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

	// Generated OLE dispatch map functions
	//{{AFX_DISPATCH(CTexexDoc)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_DISPATCH
	DECLARE_DISPATCH_MAP()
	DECLARE_INTERFACE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_TEXEXDOC_H__48CDAE51_8F02_11D3_809C_0050DA2B1C95__INCLUDED_)
