// texexDoc.cpp : implementation of the CTexexDoc class
//

#include "stdafx.h"
#include "texex.h"

#include "texexDoc.h"
#include <Image/ImageFile.h>
#include "ImageProc.h"
#include <texsyn.h>
#include "ParamDialog.h"
#include <malloc.h>
#include <bitmap.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTexexDoc

IMPLEMENT_DYNCREATE(CTexexDoc, CDocument)

BEGIN_MESSAGE_MAP(CTexexDoc, CDocument)
	//{{AFX_MSG_MAP(CTexexDoc)
	ON_COMMAND(ID_FILE_RESULT1, OnFileResult1)
	ON_UPDATE_COMMAND_UI(ID_FILE_RESULT1, OnUpdateFileResult1)
	ON_COMMAND(ID_FILE_RESULT2, OnFileResult2)
	ON_UPDATE_COMMAND_UI(ID_FILE_RESULT2, OnUpdateFileResult2)
	ON_COMMAND(ID_FILE_RESULT3, OnFileResult3)
	ON_UPDATE_COMMAND_UI(ID_FILE_RESULT3, OnUpdateFileResult3)
	ON_COMMAND(ID_IMAGE_GO, OnImageGo)
	ON_UPDATE_COMMAND_UI(ID_IMAGE_GO, OnUpdateImageGo)
	ON_COMMAND(ID_IMAGE_START, OnImageStart)
	ON_COMMAND(ID_IMAGE_STEP, OnImageStep)
	ON_COMMAND(ID_IMAGE_PARAMETERS, OnImageParameters)
	ON_COMMAND(ID_IMAGE_REFINE, OnImageRefine)
	ON_COMMAND(ID_IMAGE_ANTIALIAS, OnImageAntialias)
	ON_COMMAND(ID_FILE_RESULT4, OnFileResult4)
	ON_UPDATE_COMMAND_UI(ID_FILE_RESULT4, OnUpdateFileResult4)
	//}}AFX_MSG_MAP
	ON_COMMAND(ID_FILE_SEND_MAIL, OnFileSendMail)
	ON_UPDATE_COMMAND_UI(ID_FILE_SEND_MAIL, OnUpdateFileSendMail)
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CTexexDoc, CDocument)
	//{{AFX_DISPATCH_MAP(CTexexDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//      DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()

// Note: we add support for IID_ITexex to support typesafe binding
//  from VBA.  This IID must match the GUID that is attached to the 
//  dispinterface in the .ODL file.

// {48CDAE45-8F02-11D3-809C-0050DA2B1C95}
static const IID IID_ITexex =
{ 0x48cdae45, 0x8f02, 0x11d3, { 0x80, 0x9c, 0x0, 0x50, 0xda, 0x2b, 0x1c, 0x95 } };

BEGIN_INTERFACE_MAP(CTexexDoc, CDocument)
	INTERFACE_PART(CTexexDoc, IID_ITexex, Dispatch)
END_INTERFACE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTexexDoc construction/destruction

CTexexDoc::CTexexDoc()
: m_pimgSrc(NULL), 
m_pimgTestedMask(NULL), m_pTexIter(NULL), 
m_nWindowSize(2), m_pimgGlobalError(NULL), m_nGlobalThreshold(0.0), m_pimgGlobalMask(NULL),
m_pimgLocalMask(NULL), m_pimgErrorFlowX(NULL), m_pimgErrorFlowY(NULL), m_pimgAlphaMask(NULL)
{
	// TODO: add one-time construction code here

	EnableAutomation();

	AfxOleLockApp();
}

CTexexDoc::~CTexexDoc()
{
	AfxOleUnlockApp();
}

BOOL CTexexDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	CFileDialog dlg(TRUE);
	if(dlg.DoModal() == IDOK)
	{
		IPersistFile* pFile;
		HRESULT hr = ::CoCreateInstance(__uuidof(BMPImageFile), NULL, CLSCTX_ALL, __uuidof(IPersistFile), (void**)&pFile);
		if(FAILED(hr))
		{
			AfxMessageBox(_T("Image Class not registered."), MB_OK);
			return FALSE;
		}
		BSTR bstr = dlg.GetPathName().AllocSysString();
		hr = pFile->Load(bstr, 0);
		::SysFreeString(bstr);
		if(FAILED(hr))
		{
			pFile->Release();
			AfxMessageBox(dlg.GetPathName() + CString(" could not be loaded"), MB_OK);
			return FALSE;
		}
		IImage* pimg;
		hr = pFile->QueryInterface(__uuidof(IImage), (void**)&pimg);
		pFile->Release();
		if(FAILED(hr))
		{
			AfxMessageBox(_T("Internal Error.  Reinstall Image Class"), MB_OK);
			return FALSE;
		}
		IMalloc* pMalloc;
		CoGetMalloc(1, &pMalloc);
		PixelFormat pf;
		pf.dwSize = sizeof(PixelFormat);
		pf.dwTypeFlags = PF_FLOAT | PF_LONG;
		pf.bChannels = 4;
		hr = CoCopyImage(pMalloc, pimg, &pf, &m_pimgSrc);
		pimg->Release();
		if(FAILED(hr))
		{
			AfxMessageBox(_T("Out of memory.  Go buy more."), MB_OK);
			return FALSE;
		}
		return TRUE;
	}
	return FALSE;
}



/////////////////////////////////////////////////////////////////////////////
// CTexexDoc serialization

CArchive& operator <<(CArchive& ar, const PixelFormat& pf)
{
	ar.Write(&pf, pf.dwSize);
	return ar;
}

CArchive& operator >>(CArchive& ar, PixelFormat& pf)
{
	ar >> pf.dwSize;
	if(pf.dwSize == 0)
		return ar;
	ar.Read((char*)&pf + 4, pf.dwSize - 4);
	return ar;
}

CArchive& operator <<(CArchive& ar, IImage* pimg)
{
	PixelFormat pf;
	DWORD dwCX, dwCY;
	if(!pimg)
	{
		ar << (int)0;
		return ar;
	}
	HRESULT hr = pimg->GetFormat(&pf);
	if(FAILED(hr))
		AfxThrowArchiveException(CArchiveException::generic, ar.GetFile()->GetFileName());
	ar << pf;
	hr = pimg->GetSize(&dwCX, &dwCY);
	if(FAILED(hr))
		AfxThrowArchiveException(CArchiveException::generic, ar.GetFile()->GetFileName());
	ar << dwCX;
	ar << dwCY;
	void* ppix;
	hr = pimg->LockImage(&ppix);
	if(FAILED(hr))
		AfxThrowArchiveException(CArchiveException::generic, ar.GetFile()->GetFileName());
	int n;
	switch(pf.dwTypeFlags & 0x3)
	{
	case PF_INT | PF_BYTE :
		n = sizeof(BYTE);
		break;
	case PF_INT | PF_LONG :
		n = sizeof(long);
		break;
	case PF_FLOAT | PF_BYTE :
		n = sizeof(float);
		break;
	case PF_FLOAT | PF_LONG :
		n = sizeof(double);
		break;
	}
	ar.Write(ppix, dwCX * dwCY * pf.bChannels * n);
	pimg->UnlockImage(ppix);
	return ar;
}

CArchive& operator >>(CArchive& ar, IImage*& pimg)
{
	PixelFormat pf;
	DWORD dwCX;
	DWORD dwCY;
	ar >> pf;
	if(pf.dwSize == 0)
	{
		pimg = NULL;
		return ar;
	}
	ar >> dwCX;
	ar >> dwCY;
	HRESULT hr = GetHeapImageFactory()->CreateImage(dwCX, dwCY, &pf, &pimg);
	if(FAILED(hr))
		AfxThrowArchiveException(CArchiveException::generic, ar.GetFile()->GetFileName());
	void* ppix;
	hr = pimg->LockImage(&ppix);
	if(FAILED(hr))
	{
		pimg->Release();
		AfxThrowArchiveException(CArchiveException::generic, ar.GetFile()->GetFileName());
	}
	int n;
	switch(pf.dwTypeFlags & 0x3)
	{
	case PF_INT | PF_BYTE :
		n = sizeof(BYTE);
		break;
	case PF_INT | PF_LONG :
		n = sizeof(long);
		break;
	case PF_FLOAT | PF_BYTE :
		n = sizeof(float);
		break;
	case PF_FLOAT | PF_LONG :
		n = sizeof(double);
		break;
	}
	ar.Read(ppix, dwCX * dwCY * pf.bChannels * n);
	pimg->UnlockImage(ppix);
	return ar;
}

CArchive& operator <<(CArchive& ar, const CRectTracker& trk)
{
	ar << trk.m_nHandleSize;
	ar << trk.m_rect;
	ar << trk.m_sizeMin;
	ar << trk.m_nStyle;
	return ar;
}

CArchive& operator >>(CArchive& ar, CRectTracker& trk)
{
	ar >> trk.m_nHandleSize;
	ar >> trk.m_rect;
	ar >> trk.m_sizeMin;
	ar >> trk.m_nStyle;
	return ar;	
}

void CTexexDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
		ar << m_nGlobalThreshold;
		ar << m_nWindowSize;
		ar << m_pimgGlobalError;
		ar << m_pimgGlobalMask;
		ar << m_pimgSrc;
		ar << m_pimgTestedMask;
		ar << m_pimgLocalMask;
		ar << m_pimgErrorFlowX;
		ar << m_pimgErrorFlowY;
		ar << m_trkTexture;
		ar << m_pimgAlphaMask;

	}
	else
	{
		// TODO: add loading code here
		ar >> m_nGlobalThreshold;
		ar >> m_nWindowSize;
		ar >> m_pimgGlobalError;
		ar >> m_pimgGlobalMask;
		ar >> m_pimgSrc;
		ar >> m_pimgTestedMask;
		ar >> m_pimgLocalMask;
		ar >> m_pimgErrorFlowX;
		ar >> m_pimgErrorFlowY;
		ar >> m_trkTexture;
	}
}

/////////////////////////////////////////////////////////////////////////////
// CTexexDoc diagnostics

#ifdef _DEBUG
void CTexexDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CTexexDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CTexexDoc commands

BOOL CTexexDoc::OnOpenDocument(LPCTSTR lpszPathName) 
{
	if (!CDocument::OnOpenDocument(lpszPathName))
		return FALSE;
	
	// TODO: Add your specialized creation code here
	
	return TRUE;
}

BOOL CTexexDoc::OnSaveDocument(LPCTSTR lpszPathName) 
{
	// TODO: Add your specialized code here and/or call the base class
	
	return CDocument::OnSaveDocument(lpszPathName);
}

void CTexexDoc::OnFileResult1() 
{
	// TODO: Add your command handler code here
	CFileDialog dlg(FALSE);
	if(dlg.DoModal() == IDOK)
	{
		SIZE sz;
		HBITMAP hbmp = ::CreateBitmap(m_pimgGlobalMask, sz);
		if(!SaveBitmap(hbmp, dlg.GetPathName()))
			AfxMessageBox(_T("Unable to Save result"), MB_OK);
		::DeleteObject(hbmp);
	}
	
}

void CTexexDoc::OnUpdateFileResult1(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->Enable(m_pimgGlobalMask ? TRUE : FALSE);
}

void CTexexDoc::OnFileResult2() 
{
	// TODO: Add your command handler code here
	CFileDialog dlg(FALSE);
	if(dlg.DoModal() == IDOK)
	{
		SIZE sz;
		HBITMAP hbmp = ::CreateBitmap(m_pimgLocalMask, sz);
		if(!SaveBitmap(hbmp, dlg.GetPathName()))
			AfxMessageBox(_T("Unable to Save result"), MB_OK);
		::DeleteObject(hbmp);
	}
	
}

void CTexexDoc::OnUpdateFileResult2(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->Enable(m_pimgLocalMask ? TRUE : FALSE);
}

void CTexexDoc::OnFileResult3() 
{
	// TODO: Add your command handler code here
	CFileDialog dlg(FALSE);
	if(dlg.DoModal() == IDOK)
	{
		SIZE sz;
		HBITMAP hbmp = ::CreateBitmap(m_pimgAlphaMask, sz);
		if(!SaveBitmap(hbmp, dlg.GetPathName()))
			AfxMessageBox(_T("Unable to Save result"), MB_OK);
		::DeleteObject(hbmp);
	}
}

void CTexexDoc::OnUpdateFileResult3(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->Enable(m_pimgAlphaMask ? TRUE : FALSE);
}

void CTexexDoc::OnImageGo() 
{
	// TODO: Add your command handler code here
	OnImageStart();
	while(StepImage() > 0);
}

void CTexexDoc::OnUpdateImageGo(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->Enable(m_trkTexture.m_nStyle == (CRectTracker::dottedLine | CRectTracker::resizeOutside) ? TRUE : FALSE);
}

void CTexexDoc::OnImageStart() 
{
	// TODO: Add your command handler code here
	if(m_pimgTestedMask)
		m_pimgTestedMask->Release();
	if(m_pimgGlobalMask)
		m_pimgGlobalMask->Release();
	CSize sz;
	m_pimgSrc->GetSize((DWORD*)&sz.cx, (DWORD*)&sz.cy);
	PixelFormat pfError;
	pfError.dwSize = sizeof(PixelFormat);
	pfError.dwTypeFlags = PF_FLOAT | PF_LONG;
	pfError.bChannels = 1;
	GetHeapImageFactory()->CreateImage(sz.cx, sz.cy, &pfError, &m_pimgGlobalError);
	pfError.dwTypeFlags = PF_LONG | PF_INT;
	GetHeapImageFactory()->CreateImage(sz.cx, sz.cy, &pfError, &m_pimgErrorFlowX);
	GetHeapImageFactory()->CreateImage(sz.cx, sz.cy, &pfError, &m_pimgErrorFlowY);
	CRect r = m_trkTexture.m_rect;
	int tmp = r.top;
	r.top  = sz.cy - r.bottom;
	r.bottom = sz.cy - tmp;
	if(m_pTexIter)
		delete m_pTexIter;
	m_pTexIter = new CRectTexWindowIterator(m_pimgSrc, m_nWindowSize, r);
	if(FAILED(CreateMask(sz, r, &m_pimgTestedMask)))
		return;
	if(FAILED(CreateMask(sz, r, &m_pimgGlobalMask)))
		return;
	UpdateAllViews(NULL);
}

int CTexexDoc::StepImage()
{
	BeginWaitCursor();
	int x, y, xtest, ytest;
	int oldx, oldy;
	void* ppixSrc, *ppixError, *ppixX, *ppixY;
	double* pdError;
	int* pnX;
	int* pnY;
	DWORD dwCX, dwCY;
	m_pimgSrc->GetSize(&dwCX, &dwCY);
	m_pimgGlobalError->LockImage(&ppixError);
	m_pimgSrc->LockImage(&ppixSrc);
	m_pimgErrorFlowX->LockImage(&ppixX);
	m_pimgErrorFlowY->LockImage(&ppixY);
	pdError = (double*)ppixError;
	pnX = (int*)ppixX;
	pnY = (int*)ppixY;
	oldx = 0;
	oldy = 0;
	int dp;
	int w = 2 * m_nWindowSize + 1;
	double maxerr = (double)(w * w * 3);
	double factor = 1.0 / maxerr;
	double err;
	int errfac;
	CPixelTestIterator it(GetHeapImageFactory(), m_pimgTestedMask);
	for(it.begin(); (bool)it; ++it)
	{
		it.GetTestPixel(x, y);
		dp = (x - oldx) + dwCX * (y - oldy);
		pdError +=dp;
		pnX += dp;
		pnY += dp;
		*pdError = maxerr;
		m_pTexIter->begin();
		x -= m_nWindowSize;
		y -= m_nWindowSize;
		for(; !m_pTexIter->end(); m_pTexIter->inc())
		{
			m_pTexIter->getCoords(xtest, ytest);
			err = SSD((double*)ppixSrc, (double*)ppixSrc, dwCX, dwCY, dwCX, dwCY, 
				x, y, xtest - m_nWindowSize, ytest - m_nWindowSize, w, &errfac);
			if(err < *pdError)
			{
				*pdError = err;
				*pnX = xtest - m_nWindowSize;
				*pnY = ytest - m_nWindowSize;
			}
		}
		x += m_nWindowSize;
		y += m_nWindowSize;
		*pdError *= factor;
		oldx = x;
		oldy = y;
	}
	m_pimgGlobalError->UnlockImage(ppixError);
	m_pimgSrc->UnlockImage(ppixSrc);
	m_pimgErrorFlowX->UnlockImage(ppixX);
	m_pimgErrorFlowY->UnlockImage(ppixY);
	m_pimgTestedMask->Release();
	it.GetNewMask(&m_pimgTestedMask);
	EndWaitCursor();
	UpdateAllViews(NULL);
	return it.GetPixelsTested();
}

void CTexexDoc::OnImageStep() 
{
	StepImage();
}

void CTexexDoc::OnImageParameters() 
{
	// TODO: Add your command handler code here
	CParamDialog dlg;
	dlg.m_nWindowSize = m_nWindowSize;
	dlg.m_nThresh = m_nGlobalThreshold;
	if(dlg.DoModal() == IDOK)
	{
		m_nWindowSize = dlg.m_nWindowSize;
		m_nGlobalThreshold = dlg.m_nThresh;
		UpdateAllViews(NULL);
	}
}

void CTexexDoc::OnImageRefine() 
{
	// TODO: Add your command handler code here
	int w = 2 * m_nWindowSize + 1;
	IMalloc* pMalloc;
	CoGetMalloc(1, &pMalloc);
	m_pimgTestedMask->Release();
	if(m_pimgLocalMask)
		m_pimgLocalMask->Release();
	PixelFormat pf;
	pf.dwSize = sizeof(PixelFormat);
	m_pimgGlobalMask->GetFormat(&pf);
	CoCopyImage(pMalloc, m_pimgGlobalMask, &pf, &m_pimgTestedMask);
	CoCopyImage(pMalloc, m_pimgGlobalMask, &pf, &m_pimgLocalMask);
	pMalloc->Release();
	BeginWaitCursor();
	for(int i=0; i < w; i++)
	{
		int x, y, xtest, ytest;
		int oldx, oldy;
		void* ppixSrc, *ppixMask;
		DWORD dwCX, dwCY;
		m_pimgSrc->GetSize(&dwCX, &dwCY);
		m_pimgSrc->LockImage(&ppixSrc);
		m_pimgLocalMask->LockImage(&ppixMask);
		BYTE* pbMask = (BYTE*)ppixMask;
		oldx = 0;
		oldy = 0;
		if(!m_pTexIter)
		{
			CRect r = m_trkTexture.m_rect;
			int tmp = r.top;
			r.top  = (int)dwCY - r.bottom;
			r.bottom = (int)dwCY - tmp;
			m_pTexIter = new CRectTexWindowIterator(m_pimgSrc, m_nWindowSize, r);
		}
		int dp;
		double maxerr = (double)(w * w * 3);
		double factor = 1.0 / maxerr;
		double err;
		double errd;
		int errfac;
		CPixelTestIterator it(GetHeapImageFactory(), m_pimgTestedMask);
		for(it.begin(); (bool)it; ++it)
		{
			it.GetTestPixel(x, y);
			dp = (x - oldx) + dwCX * (y - oldy);
			pbMask += dp;
			*pbMask = 0xFF;
			m_pTexIter->begin();
			x -= m_nWindowSize;
			y -= m_nWindowSize;
			errd = maxerr;
			for(; !m_pTexIter->end(); m_pTexIter->inc())
			{
				m_pTexIter->getCoords(xtest, ytest);
				err = SSDEx((double*)ppixSrc, (double*)ppixSrc, (BYTE*)ppixMask, dwCX, dwCY, dwCX, dwCY, 
					x, y, xtest - m_nWindowSize, ytest - m_nWindowSize, w, &errfac);
				if(errfac > 0)
				{
					errd = err;
					if(errd < m_nGlobalThreshold)
						break;
				}
			}
			if(errd >= m_nGlobalThreshold)
				*pbMask = 0x00;
			x += m_nWindowSize;
			y += m_nWindowSize;
			oldx = x;
			oldy = y;
		}
		m_pimgTestedMask->Release();
		it.GetNewMask(&m_pimgTestedMask);
		m_pimgSrc->UnlockImage(ppixSrc);
		m_pimgLocalMask->UnlockImage(ppixMask);
		UpdateAllViews(NULL);
	}
	EndWaitCursor();
}

void CTexexDoc::OnImageAntialias() 
{
	// TODO: Add your command handler code here
	if(!m_pimgLocalMask)
	{
		AfxMessageBox(_T("Refinement not taken place"), MB_OK);
		return;
	}
	IImage* pimgEdge;
	IImage* pimgTexSynth;
	IImage* pimgOccSynth;
	PixelFormat pf;
	pf.dwSize = sizeof(PixelFormat);
	pf.dwTypeFlags = PF_LONG | PF_FLOAT;
	pf.bChannels = 4;
	DWORD dwCX, dwCY;
	m_pimgSrc->GetSize(&dwCX, &dwCY);
	GetHeapImageFactory()->CreateImage(dwCX, dwCY, &pf, &pimgTexSynth);
	GetHeapImageFactory()->CreateImage(dwCX, dwCY, &pf, &pimgOccSynth);
	pf.bChannels = 1;
	GetHeapImageFactory()->CreateImage(dwCX, dwCY, &pf, &m_pimgAlphaMask);
	pf.dwTypeFlags = PF_INT | PF_BYTE;
	GetHeapImageFactory()->CreateImage(dwCX, dwCY, &pf, &pimgEdge);
	FindMaskEdge(m_pimgLocalMask, pimgEdge);
	SynthTex(m_pimgSrc, pimgEdge, m_pimgErrorFlowX, m_pimgErrorFlowY, pimgTexSynth);
	SynthOcc(m_pimgSrc, m_pimgLocalMask, pimgEdge, pimgOccSynth);
	ExtractAlpha(m_pimgSrc, m_pimgLocalMask, pimgEdge, pimgTexSynth, 
		pimgOccSynth, m_pimgAlphaMask);
}

void CTexexDoc::OnFileResult4() 
{
	// TODO: Add your command handler code here
	CFileDialog dlg(FALSE);
	if(dlg.DoModal() == IDOK)
	{
		SIZE sz;
		HBITMAP hbmp = ::CreateBitmap(m_pimgGlobalError, sz);
		if(!SaveBitmap(hbmp, dlg.GetPathName()))
			AfxMessageBox(_T("Unable to Save result"), MB_OK);
		::DeleteObject(hbmp);
	}
	
}

void CTexexDoc::OnUpdateFileResult4(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->Enable(m_pimgGlobalError ? TRUE : FALSE);
}
