// TexexErrorView.cpp : implementation file
//

#include "stdafx.h"
#include "texex.h"
#include "TexexErrorView.h"
#include "TexexDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTexexErrorView

IMPLEMENT_DYNCREATE(CTexexErrorView, CErrorImageView)

CTexexErrorView::CTexexErrorView()
{
}

CTexexErrorView::~CTexexErrorView()
{
}


BEGIN_MESSAGE_MAP(CTexexErrorView, CErrorImageView)
	//{{AFX_MSG_MAP(CTexexErrorView)
	ON_WM_RBUTTONUP()
	ON_COMMAND(ID_EIMAGE_EXPORT, OnEimageExport)
	ON_WM_LBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTexexErrorView drawing

void CTexexErrorView::OnInitialUpdate()
{
	CTexexDoc* pDoc = (CTexexDoc*)GetDocument();
	if(pDoc->m_pimgGlobalError)
		SetImage(pDoc->m_pimgGlobalError);
	CErrorImageView::OnInitialUpdate();
}

void CTexexErrorView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: add draw code here
	CErrorImageView::OnDraw(pDC);
}

/////////////////////////////////////////////////////////////////////////////
// CTexexErrorView diagnostics

#ifdef _DEBUG
void CTexexErrorView::AssertValid() const
{
	CSimpleImageView::AssertValid();
}

void CTexexErrorView::Dump(CDumpContext& dc) const
{
	CSimpleImageView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CTexexErrorView message handlers

void CTexexErrorView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	// TODO: Add your specialized code here and/or call the base class
	if(pSender == this)
		return;
	CTexexDoc* pDoc = (CTexexDoc*)GetDocument();
	if(pDoc->m_pimgGlobalError)
	{
		SetImage(pDoc->m_pimgGlobalError);
		SetThreshold(pDoc->m_nGlobalThreshold);
	}
	RedrawWindow();
	
}

void CTexexErrorView::OnRButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	ClientToScreen(&point);
	CMenu menu;
	menu.LoadMenu(IDR_EIMAGE);
	menu.GetSubMenu(0)->TrackPopupMenu(TPM_LEFTALIGN, point.x, point.y, this);
	CScrollView::OnRButtonUp(nFlags, point);
	
}

void CTexexErrorView::OnEimageExport() 
{
	CTexexDoc* pDoc = (CTexexDoc*)GetDocument();
	if(!m_hbmpImage)
		return;
	CFileDialog dlg(FALSE, ".BMP", NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, "MATLAB Matrix (*.MAT)|*.MAT||", this);
	if(dlg.DoModal() == IDOK)
	{
		SaveImage(pDoc->m_pimgGlobalError, dlg.GetPathName());
	}
	
}

void CTexexErrorView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	CErrorImageView::OnLButtonDown(nFlags, point);

}

void CTexexErrorView::SetThreshold(double nNewThreshold)
{
	CErrorImageView::SetThreshold(nNewThreshold);
	CTexexDoc* pDoc = (CTexexDoc*)GetDocument();
	pDoc->m_nGlobalThreshold = nNewThreshold;
	if(pDoc->m_pimgGlobalMask)
		pDoc->m_pimgGlobalMask->Release();
	pDoc->m_pimgGlobalMask = m_pimgMask;
	pDoc->m_pimgGlobalMask->AddRef();
	RedrawWindow();
	pDoc->UpdateAllViews(this);
}
