/**
 *	Jon Rowlett
 *
 **/

#ifndef __IMAGEPROC_H__
#define __IMAGEPROC_H__

#include "Image/Image.h"

HRESULT __stdcall CoCreateImage(IMalloc* pMalloc, DWORD dwCX, DWORD dwCY, 
								PixelFormat* pPixelFormat, REFIID riid, void** ppv);
HRESULT __stdcall CoWarpImage(IMalloc* pMalloc, IImage* pSrc, double ptSrc[8], DWORD dwCX, DWORD dwCY, IImage** ppOut);
HRESULT __stdcall CoCopyImage(IMalloc* pMalloc, IImage* pSrc, PixelFormat* pNewFormat, IImage** ppOut);

HRESULT __stdcall CoExtractTextels(IMalloc* pMalloc, IImage* pSrc, double ptSrc[8], 
								   int nxdiv, int nydiv, DWORD dwCX, DWORD dwCY, IImage** ppOut);

HRESULT __stdcall CoBltPerspective(IImage* pimgSrc, double ptDest[8], IImage* pDest);

HRESULT __stdcall SaveImage(IImage* pimgSrc, LPCTSTR lpszFileName);

/**
 *  Computes the minimum resolution of a square to be extracted from the points
 *  See notes 11.25.00
 **/
void ComputeMinRes(double pts[8], double &cx, double &cy);

/**
 *  Computes average texture from several texture images
 *  See notes 11.25.01
 *  can return E_OUTOFMEMORY and IMAGE_E_DIMENSION
 */
HRESULT __stdcall CoAverageImage(IMalloc* pMalloc, IImage* pimgSrc, int nxdiv, int nydiv, IImage** ppimgOut);

HRESULT __stdcall CoCorrectPerspective(IMalloc* pMalloc, IImage* pimgSrc, double pts[8], int nxdiv, int nydiv, IImage** ppimgOut);

HRESULT __stdcall CoRepeatImage(IMalloc* pMalloc, IImage* pimgSrc, int nxdiv, int nydiv, IImage** ppimg);

typedef void (*IMGFUNC)(DWORD x, DWORD y, double src1[4], double src2[4], double dest[4]);

HRESULT __stdcall ApplyFunction(IImage* pimgSrc1, IImage* pimgSrc2, IImage* pimgDest, IMGFUNC pFunc);

HRESULT __stdcall ResampleImage(IMalloc* pMalloc, IImage* pimgSrc, DWORD dwCX, DWORD dwCY, IImage** ppimgOut);

#endif /* __IMAGEPROC_H__ */