
#include "stdafx.h"
#include "ImageProc1.h"
#define __AROS_BUILD_WINDOWS__
#include "../../arostk/objtmpl.h"
#include "../../arostk/trans.h"

#include <math.h>
#include <memory.h>
#include <fstream.h>

HRESULT ValidatePixelFormat(PixelFormat* pFormat)
{
/*	if(!pFormat)
		return E_POINTER;
	if(pFormat->dwSize != sizeof(PixelFormat))
		return IMAGE_E_PIXELFORMAT;
	if(pFormat->dwBpp > 32 || pFormat->dwBpp == 0)
		return IMAGE_E_PIXELFORMAT;
	DWORD dwMask = (DWORD)pow(2, pFormat->dwBpp << 3) - 1;
	dwMask = ~dwMask;
	if(dwMask & (pFormat->dwAlphaMask | pFormat->dwBluMask | pFormat->dwGrnMask | pFormat->dwRedMask))
		return IMAGE_E_PIXELFORMAT;
*/	return S_OK;
}

class CHeapImage : public IImage
{
public:
	CHeapImage()
		: m_pMalloc(NULL), m_dwCX(0), m_dwCY(0), m_pPixels(NULL), m_pPF(NULL)
	{
	}

	virtual ~CHeapImage()
	{
		if(m_pMalloc)
		{
			if(m_pPF)
				m_pMalloc->Free(m_pPF);
			// frees image data too
			m_pMalloc->Release();
		}
	}

	HRESULT __stdcall Create(IMalloc* pMalloc, DWORD dwCX, DWORD dwCY, PixelFormat* pPixelFormat)
	{
		HRESULT hr = S_OK;
		if(!pMalloc || !pPixelFormat)
			return E_POINTER;
		if(!dwCX || !dwCY)
			return E_INVALIDARG;
		if(FAILED(hr = ValidatePixelFormat(pPixelFormat)))
			return hr;
		// alloc everything at once
		int factor;
		switch(pPixelFormat->dwTypeFlags & 0x3)
		{
		case PF_BYTE | PF_INT :
			factor = sizeof(BYTE);
			break;
		case PF_BYTE | PF_FLOAT :
			factor = sizeof(float);
			break;
		case PF_LONG | PF_INT :
			factor = sizeof(unsigned long);
			break;
		case PF_LONG | PF_FLOAT :
			factor = sizeof(double);
			break;
		}
		DWORD dwImgSize = (dwCX * dwCY * pPixelFormat->bChannels * factor);
		m_pPF = (PixelFormat*)pMalloc->Alloc(pPixelFormat->dwSize + dwImgSize);
		if(!m_pPF)
			return E_OUTOFMEMORY;
		m_pPixels = (char*)m_pPF + pPixelFormat->dwSize;
		memcpy(m_pPF, pPixelFormat, pPixelFormat->dwSize);
		memset(m_pPixels, 0, dwImgSize);
		m_pMalloc = pMalloc;
		m_pMalloc->AddRef();
		m_dwCX = dwCX;
		m_dwCY = dwCY;
		return S_OK;
	}

	//IUnknown
	STDMETHODIMP QueryInterface(REFIID riid, void** ppv)
	{
		if(riid == IID_IUnknown)
			*ppv = static_cast<IUnknown*>(this);
		else if(riid == __uuidof(IImageBase))
			*ppv = static_cast<IImageBase*>(this);
		else if(riid == __uuidof(IImage))
			*ppv = static_cast<IImage*>(this);
		else
			return E_NOINTERFACE;
		ADDREF(*ppv)();
		return S_OK;
	}

	//IImageBase
	STDMETHODIMP LockImage(void** ppvPixels)
	{
		*ppvPixels = m_pPixels;
		return S_OK;
	}

	STDMETHODIMP UnlockImage(void* pvPixels)
	{
		return pvPixels == m_pPixels ? S_OK : E_FAIL;
	}

	STDMETHODIMP GetSize(DWORD* pdwCX, DWORD* pdwCY)
	{
		*pdwCX = m_dwCX;
		*pdwCY = m_dwCY;
		return S_OK;
	}

	STDMETHODIMP GetFormat(PixelFormat* pFormat)
	{
		if(!pFormat || pFormat->dwSize < sizeof(PixelFormat))
			return E_INVALIDARG;
		memcpy(pFormat, m_pPF, sizeof(PixelFormat));
		return S_OK;
	}

	STDMETHODIMP GetPixel(double x, double y, double* vals)
	{
		double dx, dy;
		double fracx = modf(x, &dx);
		double fracy = modf(y, &dy);
		int nx = (int)dx;
		int ny = (int)dy;
		if(fracx < 0.0)
		{
			fracx = 1 - fracx;
			nx--;
		}
		if(fracy < 0.0)
		{
			fracy = 1 - fracy;
			ny--;
		}
		BYTE* pPixel;
		double* pdPixel;
/*		if(nx >= m_dwCX - 1 || ny >= m_dwCY - 1 || nx < 0 || ny < 0)
		{
			vals[3] = 0.0;
			if(nx < 0)
				nx = 0;
			if(ny < 0)
				ny = 0;
			if(nx >= m_dwCX)
				nx = m_dwCX - 1;
			if(ny >= m_dwCY)
				ny = m_dwCY - 1;
			pPixel = (BYTE*)m_pPixels + ((nx + ny * m_dwCX) << 2);
			vals[0] = (double)*pPixel * 0.00390625;	pPixel++;
			vals[1] = (double)*pPixel * 0.00390625; pPixel++;
			vals[2] = (double)*pPixel * 0.00390625;	pPixel++;
			return S_OK;
		}*/
		vals[3] = 1.0;
		if(nx < 0)
		{
			nx = 0;
			fracx = 0.0;
			vals[3] = 0.0;
		}
		if(ny < 0)
		{
			ny = 0;
			fracy = 0.0;
			vals[3] = 0.0;
		}
		if(nx > m_dwCX-1 || ny > m_dwCY-1)
			vals[3] = 0.0;
		if(nx >= m_dwCX-1)
		{
			nx = m_dwCX-2;
			fracx = 1.0;
		}
		if(ny >= m_dwCY-1)
		{
			ny = m_dwCY-2;
			fracy = 1.0;
		}
		double fracx1 = 1 - fracx;
		double fracy1 = 1 - fracy;
		double c0 = fracx1 * fracy1;
		double c1 = fracx1 * fracy;
		double c2 = fracx * fracy;
		double c3 = fracx * fracy1;
		switch(m_pPF->dwTypeFlags & 0x3)
		{
		case PF_BYTE | PF_INT :
			{
				c0 *= 0.00390625;
				c1 *= 0.00390625;
				c2 *= 0.00390625;
				c3 *= 0.00390625;
				pPixel = (BYTE*)m_pPixels + ((nx + ny * m_dwCX) << 2);
				vals[0] = (double)*pPixel * c0;	pPixel++;
				vals[1] = (double)*pPixel * c0; pPixel++;
				vals[2] = (double)*pPixel * c0;	pPixel++;
				pPixel++;
				vals[0] += (double)*pPixel * c3;	pPixel++;
				vals[1] += (double)*pPixel * c3; pPixel++;
				vals[2] += (double)*pPixel * c3;	pPixel++;
				pPixel++;
				pPixel += (m_dwCX - 2) << 2;
				vals[0] += (double)*pPixel * c1;	pPixel++;
				vals[1] += (double)*pPixel * c1; pPixel++;
				vals[2] += (double)*pPixel * c1;	pPixel++;
				pPixel++;
				vals[0] += (double)*pPixel * c2;	pPixel++;
				vals[1] += (double)*pPixel * c2; pPixel++;
				vals[2] += (double)*pPixel * c2;	pPixel++;
				pPixel++;
			} break;
		case PF_LONG | PF_FLOAT :
			{
				pdPixel = (double*)m_pPixels + ((nx + ny * m_dwCX) << 2);
				vals[0] = *pdPixel * c0;	pdPixel++;
				vals[1] = *pdPixel * c0; pdPixel++;
				vals[2] = *pdPixel * c0;	pdPixel++;
				pdPixel++;
				vals[0] += *pdPixel * c3;	pdPixel++;
				vals[1] += *pdPixel * c3; pdPixel++;
				vals[2] += *pdPixel * c3;	pdPixel++;
				pdPixel++;
				pdPixel += (m_dwCX - 2) << 2;
				vals[0] += *pdPixel * c1;	pdPixel++;
				vals[1] += *pdPixel * c1; pdPixel++;
				vals[2] += *pdPixel * c1;	pdPixel++;
				pdPixel++;
				vals[0] += *pdPixel * c2;	pdPixel++;
				vals[1] += *pdPixel * c2; pdPixel++;
				vals[2] += *pdPixel * c2;	pdPixel++;
				pdPixel++;
			} break;
		}
//		vals[3] = 1.0;
// Assignment 1 code
#if 0
		if(x * 2 > m_dwCX)
			x = m_dwCX - x;
		if(y * 2 > m_dwCY)
			y = m_dwCY - y;
		if(x < 9 || y < 9)
			vals[3] = 0.1 + min(x, y) * 0.1;
#endif
		return S_OK;

	}

protected:
	IMalloc* m_pMalloc;
	DWORD m_dwCX;
	DWORD m_dwCY;
	PixelFormat* m_pPF;
	void* m_pPixels;
};

/*
class CBMPImage : public IImage
{
public:
	CBMPImage()
		: m_hBMP(NULL), m_pBits(NULL)
	{
	}

	virtual ~CBMPImage()
	{
		if(m_hBMP)
			::DeleteObject(m_hBMP);
	}

	//IUnknown
	STDMETHODIMP QueryInterface(REFIID riid, void** ppv)
	{
		if(riid == IID_IUnknown)
			*ppv = static_cast<IUnknown*>(this);
		else if(riid == IID_IImageBase)
			*ppv = static_cast<IImageBase*>(this);
		else if(riid == IID_IImage)
			*ppv = static_cast<IImage*>(this);
		else
			return E_NOINTERFACE;
		ADDREF(*ppv)();
		return S_OK;
	}

	//IImageBase
	STDMETHODIMP LockImage(void** ppvPixels)
	{
		BITMAP bm;
		if(::GetObject(m_hBMP, sizeof(BITMAP), &bm) == 0)
			return HRESULT_FROM_WIN32(GetLastError());
		m_pBits = bm.bmBits;
		*ppvPixels = m_pBits;
		return S_OK;
	}

	STDMETHODIMP UnlockImage(void* pvPixels)
	{
		return pvPixels == m_pBits ? S_OK : E_FAIL;
	}

	STDMETHODIMP GetSize(DWORD* pdwCX, DWORD* pdwCY)
	{
		BITMAP bm;
		if(::GetObject(m_hBMP, sizeof(BITMAP), &bm) == 0)
			return HRESULT_FROM_WIN32(GetLastError());
		*pdwCX = bm.bmWidth;
		*pdwCY = bm.bmHeight;
		return S_OK;
	}

	STDMETHODIMP GetFormat(PixelFormat* pFormat)
	{
		if(!pFormat || pFormat->dwSize < sizeof(PixelFormat))
			return E_INVALIDARG;
		BITMAP bm;
		if(::GetObject(m_hBMP, sizeof(BITMAP), &bm) == 0)
			return HRESULT_FROM_WIN32(GetLastError());
		pFormat->dwBpp = bm.bmBitsPixel;
		pFormat->dwAlphaMask = 0x00000000;
		return S_OK;
	}

	STDMETHODIMP GetPixel(double x, double y, double* vals)
	{
		return E_NOTIMPL;
	}

	void SetBitmap(HBITMAP hbm)
	{
		m_hBMP = hbm;
	}

protected:
	HBITMAP m_hBMP;
	void* m_pBits;
};

HRESULT __stdcall CoCreateBitmapImage(HBITMAP hbmp, REFIID riid, void** ppv)
{
	TCOMObject<CBMPImage>* pBmp = new TCOMObject<CBMPImage>();
	if(!pBmp)
		return E_OUTOFMEMORY;
	pBmp->SetBitmap(hbmp);
	HRESULT hr = pBmp->QueryInterface(riid, ppv);
	if(FAILED(hr))
		delete pBmp;
	return hr;
}

*/

HRESULT __stdcall CoCreateImage(IMalloc* pMalloc, DWORD dwCX, DWORD dwCY, 
								PixelFormat* pPixelFormat, REFIID riid, void** ppv)
{
	TCOMObject<CHeapImage>* pImage = new TCOMObject<CHeapImage>();
	if(!pImage)
		return E_OUTOFMEMORY;
	HRESULT hr = pImage->Create(pMalloc, dwCX, dwCY, pPixelFormat);
	if(FAILED(hr))
	{
		delete pImage;
		return hr;
	}
	hr = pImage->QueryInterface(riid, ppv);
	if(FAILED(hr))
		delete pImage;
	return hr;
}

/*HRESULT __stdcall CoWarpImage(IMalloc* pMalloc, IImageBase* pimgSrc, ImgQuad quad, IImage** ppOut)
{
	if(!pimgSrc || !pMalloc || !ppOut)
		return E_POINTER;
	Matrix3x3 matTrans;
	DWORD dwMinX = quad.pt0.x;
	DWORD dwMinY = quad.pt0.y;
	DWORD dwMaxX = quad.pt0.x;
	DWORD dwMaxY = quad.pt0.y;
	long* pts = (long*)&quad;
	int i;
	for(i=2; i < 8; i+=2)
	{
		if(pts[i] < (long)dwMinX)
			dwMinX = pts[i];
		if(pts[i] > (long)dwMaxX)
			dwMaxX = pts[i];
		if(pts[i+1] < (long)dwMinY)
			dwMinY = pts[i+1];
		if(pts[i+1] > (long)dwMaxY)
			dwMaxY = pts[i+1];
	}
	DWORD dwCX = dwMaxX - dwMinX + 1;
	DWORD dwCY = dwMaxY - dwMinY + 1;
	for(i=0; i < 8; i++)
	{
		pts[i] -= dwMinX;
		pts[++i] -= dwMinY;
	}
	Matrix3x3 matWarp;
	CreateWarpMatrix(pts, matWarp);
	InvWarpMatrix(matWarp);
	DWORD dwSrcCX;
	DWORD dwSrcCY;
	HRESULT hr = pimgSrc->GetSize(&dwSrcCX, &dwSrcCY);
	if(FAILED(hr))
		return hr;
	PixelFormat pf;
	pf.dwSize = sizeof(PixelFormat);
	hr = pimgSrc->GetFormat(&pf);
	if(FAILED(hr))
		return hr;
	Matrix3x3 matScale;
	InitIdentity(matScale);
	matScale[0] = dwSrcCX;
	matScale[4] = dwSrcCY;
	MulWarpMatrix(matScale, matWarp, matTrans);
	hr = CoCreateImage(pMalloc, dwCX, dwCY, &pf, IID_IImage, (void**)ppOut);
	if(FAILED(hr))
		return hr;
	void* pPixel = NULL;
	void* pPixelSrc = NULL;
	hr = (*ppOut)->LockImage(&pPixel);
	if(FAILED(hr))
		return hr;
	hr = pimgSrc->LockImage(&pPixelSrc);
	if(FAILED(hr))
	{
		hr = (*ppOut)->UnlockImage(pPixel);
		return hr;
	}
	DWORD* pDest = (DWORD*)pPixel;
	DWORD* pSrc = (DWORD*)pPixelSrc;
	double ptDest[3] = {0,0,1};
	double ptSrc[3];
	for(ptDest[1] = 0.0; ptDest[1] < (double)dwCY; ptDest[1]++)
		for(ptDest[0] = 0.0; ptDest[0] < (double)dwCX; ptDest[0]++)
		{
			TransformPoint(matTrans, ptDest, ptSrc);
			ptSrc[0] /= ptSrc[2];
			ptSrc[1] /= ptSrc[2];
			long x = (long)ptSrc[0];
			long y = (long)ptSrc[1];
			if(x >= 0 && y >= 0 && x < dwSrcCX && y < dwSrcCY)
				*pDest = pSrc[y * dwSrcCX + x];
			pDest++;
		}
	hr = (*ppOut)->UnlockImage(pPixel);
	hr = pimgSrc->UnlockImage(pPixelSrc);
	return hr;
}
*/

class CFileStream : public IStream
{
public:
	CFileStream()
		: m_hFile(NULL)
	{
	}

	virtual ~CFileStream()
	{
		if(m_hFile)
			CloseHandle(m_hFile);
	}

	STDMETHODIMP QueryInterface(REFIID riid, void** ppv)
	{
		if(riid == IID_IUnknown)
			*ppv = static_cast<IUnknown*>(this);
		else if(riid == IID_ISequentialStream)
			*ppv = static_cast<ISequentialStream*>(this);
		else if(riid == IID_IStream)
			*ppv = static_cast<IStream*>(this);
		else
			return E_NOINTERFACE;
		ADDREF(*ppv)();
		return S_OK;
	}

	HRESULT __stdcall Open(LPCOLESTR lpszFile)
	{
		m_hFile = ::CreateFileW(lpszFile, GENERIC_READ | GENERIC_WRITE, FILE_SHARE_READ, NULL, 
			OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
		if(!m_hFile)
			return HRESULT_FROM_WIN32(GetLastError());
		return S_OK;
	}

	//ISequentialStream
    virtual /* [local] */ HRESULT STDMETHODCALLTYPE Read( 
        /* [length_is][size_is][out] */ void __RPC_FAR *pv,
        /* [in] */ ULONG cb,
        /* [out] */ ULONG __RPC_FAR *pcbRead)
	{
		if(!::ReadFile(m_hFile, pv, cb, pcbRead, NULL))
			return HRESULT_FROM_WIN32(GetLastError());
		return S_OK;
	}
    
    virtual /* [local] */ HRESULT STDMETHODCALLTYPE Write( 
        /* [size_is][in] */ const void __RPC_FAR *pv,
        /* [in] */ ULONG cb,
        /* [out] */ ULONG __RPC_FAR *pcbWritten)
	{
		if(!::WriteFile(m_hFile, pv, cb, pcbWritten, NULL))
			return HRESULT_FROM_WIN32(GetLastError());
		return S_OK;
	}

	//IStream

    virtual /* [local] */ HRESULT STDMETHODCALLTYPE Seek( 
        /* [in] */ LARGE_INTEGER dlibMove,
        /* [in] */ DWORD dwOrigin,
        /* [out] */ ULARGE_INTEGER __RPC_FAR *plibNewPosition)
	{
		return E_NOTIMPL;
	}
    
    virtual HRESULT STDMETHODCALLTYPE SetSize( 
        /* [in] */ ULARGE_INTEGER libNewSize)
	{
		return S_OK;
	}
    
    virtual /* [local] */ HRESULT STDMETHODCALLTYPE CopyTo( 
        /* [unique][in] */ IStream __RPC_FAR *pstm,
        /* [in] */ ULARGE_INTEGER cb,
        /* [out] */ ULARGE_INTEGER __RPC_FAR *pcbRead,
        /* [out] */ ULARGE_INTEGER __RPC_FAR *pcbWritten)
	{
		return E_NOTIMPL;
	}
    
    virtual HRESULT STDMETHODCALLTYPE Commit( 
        /* [in] */ DWORD grfCommitFlags)
	{
		return S_OK;
	}
    
    virtual HRESULT STDMETHODCALLTYPE Revert( void)
	{
		return E_NOTIMPL;
	}
    
    virtual HRESULT STDMETHODCALLTYPE LockRegion( 
        /* [in] */ ULARGE_INTEGER libOffset,
        /* [in] */ ULARGE_INTEGER cb,
        /* [in] */ DWORD dwLockType)
	{
		return E_NOTIMPL;
	}
    
    virtual HRESULT STDMETHODCALLTYPE UnlockRegion( 
        /* [in] */ ULARGE_INTEGER libOffset,
        /* [in] */ ULARGE_INTEGER cb,
        /* [in] */ DWORD dwLockType)
	{
		return E_NOTIMPL;
	}
    
    virtual HRESULT STDMETHODCALLTYPE Stat( 
        /* [out] */ STATSTG __RPC_FAR *pstatstg,
        /* [in] */ DWORD grfStatFlag)
	{
		return E_NOTIMPL;
	}
    
    virtual HRESULT STDMETHODCALLTYPE Clone( 
        /* [out] */ IStream __RPC_FAR *__RPC_FAR *ppstm)
	{
		return E_NOTIMPL;
	}
        
protected:
	HANDLE m_hFile;

};

HRESULT __stdcall CoGetFileStream(LPCOLESTR lpszFilename, REFIID riid, void** ppv)
{
	TCOMObject<CFileStream>* pFile = new TCOMObject<CFileStream>();
	if(!pFile)
		return E_OUTOFMEMORY;
	HRESULT hr = pFile->Open(lpszFilename);
	if(FAILED(hr))
	{
		delete pFile;
		return hr;
	}
	hr = pFile->QueryInterface(riid, ppv);
	if(FAILED(hr))
	{
		delete pFile;
	}
	return hr;
}

HRESULT __stdcall CoWarpImage(IMalloc* pMalloc, IImage* pSrc, double ptSrc[8], DWORD dwCX, DWORD dwCY, IImage** ppOut)
{
	Matrix3x3 mat;
	double ptDest[8] = {0.0, 0.0, 0.0, dwCY - 1, dwCX - 1, dwCY - 1, dwCX - 1, 0.0};
	CreateWarpMapping(ptSrc, ptDest, mat);
	PixelFormat pf;
	pf.dwSize = sizeof(PixelFormat);
	pSrc->GetFormat(&pf);
	HRESULT hr = CoCreateImage(pMalloc, dwCX, dwCY, &pf, __uuidof(IImage), (void**)ppOut);
	if(FAILED(hr))
		return hr;
	double factor = 255.0;
	BYTE* pPixels;
	(*ppOut)->LockImage((void**)&pPixels);
	BYTE* pbDest = pPixels;
	double* pdDest = (double*)pPixels;
	double vals[4];
	double ptin[2] = {0.0,0.0};
	double ptout[2];
	int i, j;
	switch(pf.dwTypeFlags)
	{
	case PF_BYTE | PF_INT :
		{
		for(j=0, ptin[1] = 0.0; j < dwCY; j++, ptin[1]++)
			for(i=0, ptin[0] = 0.0; i < dwCX; i++, ptin[0]++, pbDest+=4)
			{
				TransformPointEx(mat, ptin, ptout);
				pSrc->GetPixel(ptout[0], ptout[1], vals);
				pbDest[0] = (BYTE)(vals[0] * factor);
				pbDest[1] = (BYTE)(vals[1] * factor);
				pbDest[2] = (BYTE)(vals[2] * factor);
				pbDest[3] = 0xff;//(BYTE)(vals[3] * factor);
			}
		} break;
	case PF_FLOAT | PF_LONG :
		{
		for(j=0, ptin[1] = 0.0; j < dwCY; j++, ptin[1]++)
			for(i=0, ptin[0] = 0.0; i < dwCX; i++, ptin[0]++, pdDest+=4)
			{
				TransformPointEx(mat, ptin, ptout);
				pSrc->GetPixel(ptout[0], ptout[1], vals);
				pdDest[0] = vals[0];
				pdDest[1] = vals[1];
				pdDest[2] = vals[2];
				pdDest[3] = 1.0;//(BYTE)(vals[3] * factor);
			}
		} break;
	}
	(*ppOut)->UnlockImage((void*)pPixels);
	return S_OK;
}

HRESULT __stdcall CoCopyImage(IMalloc* pMalloc, IImage* pSrc, PixelFormat* pNewFormat, IImage** ppOut)
{
	PixelFormat pfOld;
	pfOld.dwSize = sizeof(PixelFormat);
	pSrc->GetFormat(&pfOld);
	if(pfOld.bChannels != pNewFormat->bChannels)
		return E_FAIL;
	DWORD dwCX;
	DWORD dwCY;
	pSrc->GetSize(&dwCX, &dwCY);
	HRESULT hr = CoCreateImage(pMalloc, dwCX, dwCY, pNewFormat, __uuidof(IImage), (void**)ppOut);
	if(FAILED(hr))
		return hr;
	void* pvSrc, *pvDest;
	pSrc->LockImage(&pvSrc);
	(*ppOut)->LockImage(&pvDest);
	double factor = 1.0 / 256.0;
	double* pdSrc, *pdDest;
	float*  pfSrc, *pfDest;
	unsigned long* plSrc, *plDest;
	BYTE*  pbSrc, *pbDest;
	int i, j;
	switch(pfOld.dwTypeFlags & 0x3)
	{
	case PF_BYTE | PF_INT :
		{
			switch(pNewFormat->dwTypeFlags & 0x3)
			{
			case PF_BYTE | PF_INT :
				{
					memcpy(pvDest, pvSrc, sizeof(BYTE) * dwCX * dwCY * pfOld.bChannels);
				} break;
			case PF_BYTE | PF_FLOAT :
				{
				} break;
			case PF_LONG | PF_INT :
				{
				} break;
			case PF_LONG | PF_FLOAT :
				{
					pdDest = (double*)pvDest;
					pbSrc = (BYTE*)pvSrc;
					for(j = 0; j < dwCY; j++)
						for(i = 0; i < dwCX; i++, pbSrc += 4, pdDest+=4)
						{
							pdDest[0] = pbSrc[0] * factor;
							pdDest[1] = pbSrc[1] * factor;
							pdDest[2] = pbSrc[2] * factor;
							pdDest[3] = pbSrc[3] * factor;
						}
				} break;
			}
		} break;
	case PF_BYTE | PF_FLOAT :
		{
			switch(pNewFormat->dwTypeFlags & 0x3)
			{
			case PF_BYTE | PF_INT :
				{
				} break;
			case PF_BYTE | PF_FLOAT :
				{
				} break;
			case PF_LONG | PF_INT :
				{
				} break;
			case PF_LONG | PF_FLOAT :
				{
				} break;
			}
		} break;
	case PF_LONG | PF_INT :
		{
			switch(pNewFormat->dwTypeFlags & 0x3)
			{
			case PF_BYTE | PF_INT :
				{
				} break;
			case PF_BYTE | PF_FLOAT :
				{
				} break;
			case PF_LONG | PF_INT :
				{
				} break;
			case PF_LONG | PF_FLOAT :
				{
				} break;
			}
		} break;
	case PF_LONG | PF_FLOAT :
		{
			switch(pNewFormat->dwTypeFlags & 0x3)
			{
			case PF_BYTE | PF_INT :
				{
					pdSrc = (double*)pvSrc;
					pbDest = (BYTE*)pvDest;
					for(j = 0; j < dwCY; j++)
						for(i = 0; i < dwCX; i++, pdSrc += 4, pbDest+=4)
						{
							pbDest[0] = (BYTE)(pdSrc[0] * 255.0);
							pbDest[1] = (BYTE)(pdSrc[1] * 255.0);
							pbDest[2] = (BYTE)(pdSrc[2] * 255.0);
							pbDest[3] = (BYTE)(pdSrc[3] * 255.0);
						}
				} break;
			case PF_BYTE | PF_FLOAT :
				{
				} break;
			case PF_LONG | PF_INT :
				{
				} break;
			case PF_LONG | PF_FLOAT :
				{
					memcpy(pvDest, pvSrc, sizeof(double) * dwCX * dwCY * pfOld.bChannels);
				} break;
			}
		} break;
	}
	pSrc->UnlockImage(pvSrc);
	(*ppOut)->UnlockImage(pvDest);
	return S_OK;
}

HRESULT __stdcall CoExtractTextels(IMalloc* pMalloc, IImage* pSrc, double ptSrc[8], 
								   int nxdiv, int nydiv, DWORD dwCX, DWORD dwCY, IImage** ppOut)
{
	Matrix3x3 matWarp;
	CreateWarpMatrix(ptSrc, matWarp);
	double dx = 1.0 / (double)nxdiv;
	double dy = 1.0 / (double)nydiv;
	int n;
	double ptin[8];
	double ptout[8];
	ptin[0] = 0.0;
	ptin[1] = 0.0;
	ptin[2] = 0.0;
	ptin[3] = dy;
	ptin[4] = dx;
	ptin[5] = dy;
	ptin[6] = dx;
	ptin[7] = 0.0;
	int i , j;
	for( j = 0, n=0; j < nydiv; j++)
	{
		for(i = 0; i < nxdiv; i++, n++)
		{
			TransformPointEx(matWarp, ptin, ptout);
			TransformPointEx(matWarp, ptin + 2, ptout + 2);
			TransformPointEx(matWarp, ptin + 4, ptout + 4);
			TransformPointEx(matWarp, ptin + 6, ptout + 6);
			CoWarpImage(pMalloc, pSrc, ptout, dwCX, dwCY, &ppOut[n]);
			ptin[0] += dx;
			ptin[2] += dx;
			ptin[4] += dx;
			ptin[6] += dx;
		}
		ptin[0] = 0.0;
		ptin[1] += dy;
		ptin[2] = 0.0;
		ptin[3] += dy;
		ptin[4] = dx;
		ptin[5] += dy;
		ptin[6] = dx;
		ptin[7] += dy;
	}
	return S_OK;
}

HRESULT __stdcall CoBltPerspective(IImage* pimgSrc, double ptDest[8], IImage* pDest)
{
	Matrix3x3 matWarp;
	DWORD dwdCX, dwdCY;
	pimgSrc->GetSize(&dwdCX, &dwdCY);
	double ptSrc[8];
	ptSrc[0] = 0.0;
	ptSrc[1] = 0.0;
	ptSrc[2] = 0.0;
	ptSrc[3] = (double)dwdCY;
	ptSrc[4] = (double)dwdCX;
	ptSrc[5] = (double)dwdCY;
	ptSrc[6] = (double)dwdCX;
	ptSrc[7] = 0.0;
	CreateWarpMapping(ptSrc, ptDest, matWarp);
	int nBoundXMin, nBoundXMax, nBoundYMin, nBoundYMax;
	nBoundXMin = (int)ptDest[0];
	nBoundXMax = (int)ptDest[0];
	nBoundYMin = (int)ptDest[1];
	nBoundYMax = (int)ptDest[1];
	int i;
	for(i=2; i < 8; i++)
	{
		if(ptDest[i] < nBoundXMin)
			nBoundXMin = (int)ptDest[i];
		if(ptDest[i] > nBoundXMax)
			nBoundXMax = (int)ptDest[i];
		i++;
		if(ptDest[i] < nBoundYMin)
			nBoundYMin = (int)ptDest[i];
		if(ptDest[i] > nBoundYMax)
			nBoundYMax = (int)ptDest[i];
	}
	DWORD dwImgCX, dwImgCY;
	pDest->GetSize(&dwImgCX, &dwImgCY);
	if(nBoundXMin < 0)
		nBoundXMin = 0;
	if(nBoundXMax >= dwImgCX)
		nBoundXMax = dwImgCX - 1;
	if(nBoundYMin < 0)
		nBoundYMin = 0;
	if(nBoundYMax >= dwImgCY)
		nBoundYMax = dwImgCY - 1;
	double *pDestImg;
	double *pDestPix;
	pDest->LockImage((void**)&pDestImg);
	double ptin[2];
	double ptout[2];
	int j;
	ptin[0] = 0.0;
	ptin[1] = 0.0;
	double vals[4];
	pDestPix = pDestImg + (nBoundYMin * dwImgCX + nBoundXMin)*4;
	ptin[0] = (double)nBoundXMin;
	ptin[1] = (double)nBoundYMin;
	for(j = nBoundYMin; j <= nBoundYMax; j++)
	{
		for(i = nBoundXMin; i <= nBoundXMax; i++, pDestPix+=4)
		{
			TransformPointEx(matWarp, ptin, ptout);
			pimgSrc->GetPixel(ptout[0], ptout[1], vals);
			pDestPix[0] += (vals[0] - pDestPix[0]) * vals[3];
			pDestPix[1] += (vals[1] - pDestPix[1]) * vals[3];
			pDestPix[2] += (vals[2] - pDestPix[2]) * vals[3];
			ptin[0]++;
		}
		ptin[1]++;
		ptin[0] = (double)nBoundXMin;
		pDestPix += 4*(nBoundXMin + dwImgCX - nBoundXMax - 1);
	}
	pDest->UnlockImage((void*)pDestImg);
	
	return S_OK;
}

HRESULT __stdcall SaveImage(IImage* pimgSrc, LPCTSTR lpszFileName)
{
	static double f = 1.0 / 3.0;
	ofstream of(lpszFileName);

	DWORD dwCX;
	DWORD dwCY;
	double* pimg;
	pimgSrc->LockImage((void**)&pimg);
	double* p = pimg;
	pimgSrc->GetSize(&dwCX, &dwCY);
	of << "% Image (" << dwCX << ", " << dwCY << ")\n";
	for(DWORD j = 0; j < dwCY; j++)
	{
		for(DWORD i = 0; i < dwCX; i++, p+=4)
		{
			double d = (p[0] + p[1] + p[2]) * f;
			of << d << " ";
		}
		of << "\n";
	}
	pimgSrc->UnlockImage((void*)pimg);
	return S_OK;
}

double distance(double pt0[2], double pt1[2])
{
	double dx = pt0[0] - pt1[0];
	double dy = pt0[1] - pt1[1];
	return sqrt(dx * dx + dy * dy);
		
}

void ComputeMinRes(double pts[8], double &cx, double &cy)
{
/*	Matrix3x3 mat;
	CreateWarpMatrix(pts, mat);
	InvWarpMatrix(mat);
	double ptcorner[8] = {0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0};
	double pt[16];
	pt[0] = pts[0] + 1.0;
	pt[1] = pts[1];
	pt[2] = pts[0];
	pt[3] = pts[1] + 1.0;
	pt[4] = pts[2] + 1.0;
	pt[5] = pts[3];
	pt[6] = pts[2];
	pt[7] = pts[3] - 1.0;
	pt[8] = pts[4] - 1.0;
	pt[9] = pts[5];
	pt[10] = pts[4];
	pt[11] = pts[5] - 1.0;
	pt[12] = pts[6] - 1.0;
	pt[13] = pts[7];
	pt[14] = pts[6];
	pt[15] = pts[7] + 1.0;
	double ptout[2];
	double dmin = 2.0;
	for(int i=0; i < 16; i+=2)
	{
		TransformPointEx(mat, pt + i, ptout);
		ptout[0] -= ptcorner[i >> 1];
		ptout[1] -= ptcorner[(i >> 1) + 1];
		double d = ptout[0] * ptout[0] + ptout[1] * ptout[1];
		if(d < dmin)
			dmin = d;
	}
	dmin = sqrt(dmin);
	cx = cy = 1.0 / dmin;*/
	cx = max(distance(pts + 0, pts + 6), distance(pts + 2, pts + 4));
	cy = max(distance(pts + 0, pts + 2), distance(pts + 4, pts + 6));
}

HRESULT __stdcall CoAverageImage(IMalloc* pMalloc, IImage* pimgSrc, int nxdiv, int nydiv, IImage** ppimgOut)
{
	DWORD dwSrcCX, dwSrcCY;
	DWORD dwCX, dwCY;
	PixelFormat pf;
	pf.dwSize = sizeof(PixelFormat);
	pf.dwTypeFlags = PF_FLOAT | PF_LONG;
	pf.bChannels = 4;
	HRESULT hr = pimgSrc->GetSize(&dwSrcCX, &dwSrcCY);
	if(FAILED(hr))
		return hr;
	dwCX = dwSrcCX / nxdiv;
	dwCY = dwSrcCY / nydiv;
	if(dwCX * nxdiv != dwSrcCX || dwCY * nydiv != dwSrcCY)
		return IMAGE_E_DIMENSION;
	IImage* pimg;
	hr = ::CoCreateImage(pMalloc, dwCX, dwCY, &pf, __uuidof(IImage), (void**)&pimg);
	if(FAILED(hr))
		return hr;
	void* ppixDest;
	void* ppixSrc;
	pimgSrc->LockImage(&ppixSrc);
	pimg->LockImage(&ppixDest);
	double* pDest;
	double* pTex;
	double* pSrc;
	DWORD i, j, k, l;
	DWORD dRow = (dwSrcCX - dwCX) * 4;
	DWORD dTexRow = (dwCY * dwSrcCX - dwSrcCX) * 4;
	for(l = 0, pTex = (double*)ppixSrc; l < (DWORD)nydiv; l++, pTex += dTexRow)
		for(k = 0; k < (DWORD)nxdiv; k++, pTex += (4 * dwCX))
		{
			pDest = (double*)ppixDest;
			pSrc = pTex;
			for(j = 0; j < dwCY; j++, pSrc+=dRow)
				for(i=0; i < dwCX; i++, pDest+=4, pSrc+=4)
				{
					pDest[0] += pSrc[0];
					pDest[1] += pSrc[1];
					pDest[2] += pSrc[2];
					pDest[3] += pSrc[3];
				}
		}
	double factor = 1.0 / (nxdiv * nydiv);
	pDest = (double*)ppixDest;
	for(j = 0; j < dwCY; j++)
		for(i=0; i < dwCX; i++, pDest+=4)
		{
			pDest[0] *= factor;
			pDest[1] *= factor;
			pDest[2] *= factor;
			pDest[3] *= factor;
		}
	pimgSrc->UnlockImage(ppixSrc);
	pimg->UnlockImage(ppixDest);
	*ppimgOut = pimg;
	return S_OK;
}

HRESULT __stdcall CoCorrectPerspective(IMalloc* pMalloc, IImage* pimgSrc, double pts[8], int nxdiv, int nydiv, IImage** ppimgOut)
{
	double scx, scy;
	::ComputeMinRes(pts, scx, scy);
	int nx = (int)(scx / (double)nxdiv);
	int ny = (int)(scy / (double)nydiv);
	if(nx * nxdiv < scx)
		nx++;
	if(ny * nydiv < scy)
		ny++;
	return ::CoWarpImage(pMalloc, pimgSrc, pts, nx * nxdiv, ny * nydiv, ppimgOut);
}

HRESULT __stdcall CoRepeatImage(IMalloc* pMalloc, IImage* pimgSrc, int nxdiv, int nydiv, IImage** ppimg)
{
	DWORD dwCX, dwCY;
	pimgSrc->GetSize(&dwCX, &dwCY);
	PixelFormat pf;
	pf.dwSize = sizeof(PixelFormat);
	pf.dwTypeFlags = PF_FLOAT | PF_LONG;
	pf.bChannels = 4;
	HRESULT hr = ::CoCreateImage(pMalloc, dwCX * nxdiv, dwCY * nydiv, &pf, __uuidof(IImage), (void**)ppimg);
	if(FAILED(hr))
		return hr;
	IImage* pimg = *ppimg;
	void* ppixDest;
	void* ppixSrc;
	DWORD dwSrcPitch = dwCX * 4;
	DWORD dwDestPitch = dwCX * nxdiv * 4;
	DWORD dwRowPitch = dwDestPitch * (dwCY -1);
	pimgSrc->LockImage(&ppixSrc);
	pimg->LockImage(&ppixDest);
	DWORD j;
	double* pDest, *pDest2;
	double* pSrc;
	for(j = 0, pDest=(double*)ppixDest, pSrc=(double*)ppixSrc; j < dwCY; j++)
	{
		pDest2 = pDest;
		for(int l=0; l < nydiv; l++, pDest2 += dwRowPitch)
			for(int k = 0; k < nxdiv; k++)
			{
				memcpy((void*)pDest2, (void*)pSrc, dwSrcPitch * sizeof(double));
				pDest2 += dwSrcPitch;
			}
		pDest += dwDestPitch;
		pSrc += dwSrcPitch;
	}
	pimgSrc->UnlockImage(&ppixSrc);
	pimg->UnlockImage(&ppixDest);
	return S_OK;
}

HRESULT __stdcall ApplyFunction(IImage* pimgSrc1, IImage* pimgSrc2, IImage* pimgDest, IMGFUNC pFunc)
{
	DWORD dwCX, dwCY;
	pimgSrc1->GetSize(&dwCX, &dwCY);
	void* ppixSrc1, *ppixSrc2, *ppixDest;
	pimgSrc1->LockImage(&ppixSrc1);
	pimgSrc2->LockImage(&ppixSrc2);
	pimgDest->LockImage(&ppixDest);
	double* pSrc1 = (double*)ppixSrc1;
	double* pSrc2 = (double*)ppixSrc2;
	double* pDest = (double*)ppixDest;
	for(DWORD j=0; j < dwCY; j++)
		for(DWORD i=0; i < dwCX; i++, pSrc1+=4, pSrc2+=4, pDest+=4)
		{
			pFunc(i, j, pSrc1, pSrc2, pDest);
		}
	pimgSrc1->UnlockImage(ppixSrc1);
	pimgSrc2->UnlockImage(ppixSrc2);
	pimgDest->UnlockImage(ppixDest);
	return S_OK;
}

HRESULT __stdcall ResampleImage(IMalloc* pMalloc, IImage* pimgSrc, DWORD dwCX, DWORD dwCY, IImage** ppimgOut)
{
	PixelFormat pf;
	DWORD dwCXSrc, dwCYSrc;
	pimgSrc->GetSize(&dwCXSrc, &dwCYSrc);
	double xfac = (double)dwCXSrc / (double)dwCX;
	double yfac = (double)dwCYSrc / (double)dwCY;
	pf.dwSize = sizeof(PixelFormat);
	pf.dwTypeFlags = PF_LONG | PF_FLOAT;
	pf.bChannels = 4;
	HRESULT hr = CoCreateImage(pMalloc, dwCX, dwCY, &pf, __uuidof(IImage), (void**)ppimgOut);
	if(FAILED(hr))
		return hr;
	void* ppix;
	double pt[2] = {0.0, 0.0};
	(*ppimgOut)->LockImage(&ppix);
	double* pDest = (double*)ppix;
	double vals[4];
	for(DWORD j=0; j < dwCY; j++, pt[1] += yfac, pt[0]=0.0)
		for(DWORD i=0; i < dwCX; i++, pt[0] += xfac, pDest+=4)
		{
			pimgSrc->GetPixel(pt[0], pt[1], vals);
			memcpy(pDest, vals, 4 * sizeof(double));
		}
	(*ppimgOut)->UnlockImage(ppix);
	return S_OK;
}
