#include "stdafx.h"

#include "ImageProc.h"

HRESULT __stdcall CreateMask(const SIZE& szImg, const RECT& rRegion, IImage** ppimgOut)
{
	RECT r = rRegion;
	IMalloc* pMalloc;
	PixelFormat pf;
	pf.dwSize = sizeof(PixelFormat);
	pf.dwTypeFlags = PF_INT | PF_BYTE;
	pf.bChannels = 1;
	HRESULT hr = CoGetMalloc(1, &pMalloc);
	if(FAILED(hr))
		return hr;
	hr = ::CoCreateImage(pMalloc, (DWORD)szImg.cx, (DWORD)szImg.cy, &pf, __uuidof(IImage), (void**)ppimgOut);
	if(FAILED(hr))
		return hr;
	void* ppix;
	(*ppimgOut)->LockImage(&ppix);
	BYTE* pb = (BYTE*)ppix;
	memset(pb, 0, sizeof(BYTE) * szImg.cx * szImg.cy);
	pb += szImg.cx * r.top + r.left;
	r.bottom = min(r.bottom, szImg.cy - 1);
	r.right = min(r.right, szImg.cx - 1);
	int dy = szImg.cx - (r.right - r.left + 1);
	for(int j = r.top; j <= r.bottom; j++, pb += dy)
		for(int i=r.left; i <= r.right; i++, pb++)
			*pb = 0xFF;
	(*ppimgOut)->UnlockImage(ppix);
	return S_OK;
}
