﻿// nw_widgets_v1.0.js
// Author(s): Nehal Shah, Paul Waldschmidt, Michael Trythall, David Johnson
// Version: 1.0
// Created: 9/12/2007
// Updated: 10/29/2007


function BoxCollection(node) {
	var obj = this;
	
	this.node = node;
	this.views = {};
	this.tabs = {};

	this.toggleTab = function(num) {
		this.views.each(function(i) { (i!=num)?($(this).hide()):($(this).show()); });
		this.tabs.each(function(i) {
			var lastTab = obj.tabs.size()-1;
			
			if((num==0) && (i==0)) {
				$(this).addClass('factive');
			} else {
				$(this).removeClass('factive');
			}	

			if( (num-1)==i ) {
				$(this).addClass('prior');
			} else {
				$(this).removeClass('prior');
			}
			
			if(i!=num) {
				$(this).removeClass('active');
			} else {
				$(this).removeClass('prior')
				$(this).addClass('active'); 
			}
			
			if( (i == lastTab) && (num == lastTab) ) {
				$(this).addClass('lactive');
			} else {
				$(this).removeClass('lactive');
			}
		});
	}

	this.init = function() {
		this.tabs = $(node).find('.tabs').find('li');
		this.views = $(node).find('.box');		
		obj.tabs.each(function(i) { $(this).find('a').get()[0].onclick = function() { obj.toggleTab(i); return false;} });
	}

	this.init();
}

/* XXX */



/* ShareLinks Object */
function ShareLinks(Container) {
    this.Visible = false;
    this.FullyExpanded = false;
    this.Container = Container;
    
	this.hide = function() {
		$(this.Container).fadeOut('fast');
		this.Visible = false;
	}
	
	this.show = function() {
	    var pos = GetPos($('#ToolBox li.social').get(0));
	    var sl = [parseInt($('.SocialLinks').height()*.32), parseInt($('.SocialLinks').width()*.9)];
	    $(this.Container).css('left',(pos[0]+sl[1])+'px');
	    $(this.Container).css('top',(pos[1]-sl[0])+'px');
		$(this.Container).fadeIn('fast');
		this.Visible = true;
	}
}


Newsweek.Widget.FontSizeSlider = {
    
    init : function(obj, width, caretWidth) //args: obj, width, caretWidth, onAfterResize
    {
        var slider = {
            dragging       : false,
            width          : width,
            percent        : 0,
            origFontSize   : 1,
            lineHeightRate : 0.416667,
            container      : obj,
            caret          : $('div', obj).slice(0, 1),
            caretWidth     : caretWidth
        }
                
        $(slider.caret).mousedown(function() {
            if(slider.dragging) {return;};
            
            slider.dragging = true;
        });
        
        $(document).mousemove(function(e) {
            Newsweek.Widget.FontSizeSlider.onSliderMouseMove(e, slider);
        });
        
        $(document).mouseup(function(e) {
            Newsweek.Widget.FontSizeSlider.onSliderMouseUp(e, slider);       
        });        
    },
    
    slideToStart : function(slider)
    {
        this.slideTo(0, slider)
    },
    
    slideToEnd : function(slider)
    {
        var X = slider.width - slider.caretWidth
        this.slideTo(X, slider);    
    },
    
    slideTo : function(X, slider)
    {
        $(slider.caret).css('left', X + 'px');
        slider.percent = (X / slider.width);
        //this.Percent = ((X + (this.Caret.Width / 2)) / this.Width) * 100;    
    },
    
    onSliderMouseUp : function(e, slider)
    {
        if (slider.dragging)
        {
            slider.dragging = false;

            //if (slider.OnAfterResize != null)
            //{
               this.onAfterResize(slider);
            //}
        }    
    },
    
    onSliderMouseMove : function(e, slider)
    {
        if (!slider.dragging) {return;};
        
        var MouseP = GetEventXY(e);
        var MouseX = MouseP[0];
        var MouseY = MouseP[1];
        
        var SliderP = GetPos(slider.container);
        SliderX = getRealLeft(slider.container);
        
        //var SliderX = SliderP[0];
        //var SliderY = SliderP[1];

        if (MouseX < (SliderX + (slider.caretWidth / 2))) // left of slider
        {
            this.slideToStart(slider);
        }
        else if (MouseX > (SliderX + slider.width - slider.caretWidth)) // right of slider
        {
            this.slideToEnd(slider);
        }
        else // inside slider
        {
            var X = (MouseX - SliderX - (slider.caretWidth / 2))
            this.slideTo(X, slider);
        }
    },
    
    onAfterResize : function(slider)
    {
        var NewSize = slider.origFontSize;

        if (slider.percent > 0)
        {
            NewSize = slider.origFontSize + (slider.origFontSize * slider.percent);
        }
        
        $('#content').css('font-size', NewSize + 'em');
        slider.dragging = false;
    }
}


Newsweek.Widget.Peek = {
    
    strQueryParam : '/output/thepeek',
    strLoadingImg : '',
    intRequestTimeout : 500000,
    arrSections : [],
    
    init : function(objCurrentPeek, args) // args
    {
        $("div.ThePeek").each(function(i){
            
            var objPeek = this;
                 
            objPeek = {
                peekId      : this.id,
                tabs        : $("div.box div.content div.peekBox div.content div.sectionWrapper ul.peekSections li", this).slice(0),
                sections    : $("div.box div.content div.peekBox div.content div.sectionWrapper ul.peekSections", this),
                content     : $("div.box div.content div.peekBox div.content div.contentWrapper div.peekContent", this),
                initHeight  : $("div.box div.content div.peekBox div.content div.sectionWrapper ul.peekSections", this).height()
            };
            
            Newsweek.Widget.Peek.setHandler(objPeek);
        });     
    },
    
    setHandler : function(objPeek)
    {    
       $("a", objPeek.tabs).click(function(){
        
            $(this).blur();
            
            if($(this).attr("class") == 'selected')
            {
                return false;
            }
            
            $(objPeek.tabs).removeClass("peekSelected").addClass("peekOff");
            $(objPeek.tabs).children("a").removeClass("selected");
            
            if(objPeek.peekId == "mmWrapper")
            {
                Newsweek.Widget.Peek.strQueryParam = '/output/multimediaguide';
                $("../../li", this).removeClass("lightTan");
                $("../../li:even", this).slice(1).addClass("medTan");            
            }
            
            $(this).parent("li").removeClass("peekOff").addClass("peekSelected");
            $(this).addClass("selected");                               
            
            Newsweek.Widget.Peek.getAjaxRequest(this, objPeek);
            
            return false;
        });
    },
    
    getAjaxRequest : function(source, objPeek) // 
    { 
        $.ajax({
           beforeSend : function()
           {
               $(objPeek.content).empty();
               $(objPeek.content).append('<div class="loading peekld"><span>Loading</span></div>');           
           },
           url : detectProxy(source + this.strQueryParam),
           success :function(html) 
           {    
                $(objPeek.content).html(html);
                Newsweek.Widget.QuickRead();
				peekAdCall(source.id);
				
           },
           error : function()
           {
               $(objPeek.content).html("<span class='peekError'>We are currently unable to return the requested content. Please try again later.</span>");
           }           
        });        
    }
};

Newsweek.Widget.Overlay = {
    
    isActive : false,

    init : function(dBox, src)
    {
        if(this.isActive){return false;}
        
        var modal = document.createElement('div');
        modal.id = 'modal2';
        $(modal).insertBefore("#nwContainer");
    
        var overlay = document.createElement('div');
        overlay.id = 'overlay2';
        var docHeight = getDocHeight();
        
        $(overlay).css({
            height: docHeight + 'px',
            opacity : 0                
        });
        
        $(overlay).appendTo("#modal2");
        $(dBox.box).appendTo("#modal2");
        
        if(dBox.bIsCentered)
        {
            $(dBox.box).center();
            
            $(window).resize(function(){
                $(dBox.box).center();
            });
            
            if(dBox.bIsScrollable)
            {
                var scroll = getScrollTop();   
                
                window.onscroll = function(e){
                    var scroll = getScrollTop();
                    var scrollDelay = setTimeout(function(){
                        $(dBox.box).css({
                            top : (scroll + 120) + 'px'
                        });
                    }, 250)
                } 
            }                        
        }
        else
        {
            $(window).resize(function(){
                
                Newsweek.Widget.DialogBox.resetCoord(dBox, src);
            });             
         }
                
        this.checkEmbedded();                
        this.showOverlay(overlay, modal, dBox);
    },
    
    checkEmbedded : function()
    {
        if($("embed").length > 0 || $("object").length > 0 || $("select").length > 0)    
        {    
            $("object, embed, select, iframe").each(function(i){

                if($(this).attr('style') && $(this).attr('style') != '')
                {
                    var strAttr = $(this).attr('style');
                    
                    if(strAttr.match(/(visibility:\s*)(visible)(;|$)/gi))
                    {   
                        var strReplace = strAttr.replace(/(visibility:\s*)([^;]*)(;|$)/gi, "$1hidden$3");
                        $(this).attr('style', '' + strReplace + '');
                    }
                    
                    if(strAttr.match(/(visibility:\s*)(hidden)(;|$)/gi))
                    {
                        var strReplace = strAttr.replace(/(visibility:\s*)([^;]*)(;|$)/gi, "$1visible$3");
                        $(this).attr('style', '' + strReplace + '');
                    }
                } 
                else
                {
                    if($(this).css('visibility') == 'hidden')
                    {
                        $(this).css('visibility', 'visible');
                    }
                    else
                    {
                        $(this).css('visibility', 'hidden');
                    }
                }                   
            });
        }               
    }, 
    
    showOverlay : function(overlay, modal, dBox)
    {        
        $(overlay).animate({opacity : .4,'display':'block'}, 250, function(){
           
            $(this).click(function(e){
                if(e.target == this)            
                {
                    Newsweek.Widget.Overlay.hideOverlay();                        
                }
            });
            
            $(dBox.box).find(".closeModal").click(function(e){
                Newsweek.Widget.Overlay.hideOverlay(overlay, modal);                        
            });  
        });        
    },
    
    hideOverlay : function(overlay, modal)
    {
        $("#dialog").remove();
        
        $("#overlay2").animate({opacity : 0}, 250, function(){           
           
           $("#modal2").empty().remove();
           Newsweek.Widget.Overlay.checkEmbedded();
           $("embed").css("visibility", "visible");            
           $("object").css("visibility", "visible");   
           $("select").css("visibility", "visible");            
           $("iframe").css("visibility", "visible");            
           
           Newsweek.Widget.DialogBox.isActive = false;           
           
           $(".closeModal").unbind('click');
           $(window).unbind("resize");
        });
    }
};


Newsweek.Widget.DialogBox = {
     
    isActive : false,

    init : function(output, url, objSource, html, adCall, args, evtTarget) //params : source, url, html, ouput;   arg: bIsModal, bIsCentered, bIsScrollable 
    {
        var dBox;

        dBox = {
            box : $("<div id='dialog'></div>"),
            objSource : (objSource) ? objSource : false,
            url : (url) ? url : null,        
            html : (html) ? html : null,
            adCall : (adCall) ? adCall : null,
            output : (output) ? output : null,
            bIsModal  : (!args.bIsModal) ? false : true,      
            bIsScrollable  : (args.bIsScrollable) ? args.bIsScrollable : false,
            bIsCentered  : (args.bIsCentered) ? args.bIsCentered : false,
            adjLeft : (args.adjLeft) ? args.adjLeft : 0,
            adjTop : (args.adjTop) ? args.adjTop : 0,
            evtTarget : (evtTarget) ? evtTarget : null,
            errorMsg : 'We are currently unable to process your request'     
        }

        if(dBox.url || !dBox.objSource)
        {        
            if(this.isActive) {return;};
            
            Newsweek.Widget.DialogBox.isActive = true;            
            Newsweek.Widget.DialogBox.getBoxContent(dBox);
        }
        else
        {    
            
			$("" + dBox.objSource + "").unbind("click");
            
            $("" + dBox.objSource + "").click(function(e){ 

                if(Newsweek.Widget.DialogBox.isActive) {return false;};                
                
                Newsweek.Widget.DialogBox.isActive = true;
                
                var href = this.getAttribute('href');                     
                    
                $("#modal, #dialog").remove();                                 
                
                if(href != '') 
                {   
                    dBox.url = $(this).attr("href");
                }                
                
                Newsweek.Widget.DialogBox.getBoxContent(dBox, this);
                
                return false;
            });
        }
    },
    
    getBoxContent : function(dBox, src)
    {   
        if(dBox.url != null && dBox.url != '#')
        {
            var link = dBox.url;
              
            this.getAjaxRequest(dBox, link, src);
        }
        else
        {
            this.setBoxContent(dBox, '', src);
        }
    },
    
    getAjaxRequest : function(dBox, link, src)
    {
        $.ajax({
          dataType : 'html',
          url: detectProxy(link + '/output/' + dBox.output),
          success: function(html)
          {
            Newsweek.Widget.DialogBox.setBoxContent(dBox, html, src);
          },
          error : function(html, msg, e)
          {
            $(dBox.box).html(Newsweek.Widget.DialogBox.errorMsg);
            
            return;
          }   
        });       
    },
    
    setBoxContent : function(dBox, html, src)
    {         
        if(html != '')
        {
            $(dBox.box).html(html);
        }
        else
        {
            $(dBox.box).html(dBox.html);
        }
        this.setCoord(dBox, src);
    },
    
    setCoord : function(dBox, src)
    {   
        if(dBox.bIsScrollable)
        {
            var scroll = getScrollTop();   
            
            window.onscroll = function(e){
                var scroll = getScrollTop();
                var scrollDelay = setTimeout(function(){
                    $(dBox.box).css({
                        top : (scroll + 120) + 'px'
                    });
                }, 250)
            } 
        }
        else
        {
            var targetX;
            var targetY;
        
            if(dBox.objSource)
            {
                targetX = getRealLeft(src);
                targetY = getRealTop(src);            
            }
            else
            {
                targetX = getRealLeft(dBox.evtTarget);
                targetY = getRealTop(dBox.evtTarget);                        
            }

            window.onscroll = null;              
            $(dBox.box).css("left", targetX + (dBox.adjLeft) + 'px');
            $(dBox.box).css("top", targetY + (dBox.adjTop) + 'px');
        }
        
        this.showDBox(dBox, src);
        
        this.showAd(dBox);
             
    }, 
    
    resetCoord : function(dBox, src)
    {
        if(!dBox.bIsScrollable)
        {
            var targetX;
            var targetY;
        
            if(dBox.objSource)
            {
                targetX = getRealLeft(src);
                targetY = getRealTop(src);            
            }
            else
            {
                targetX = getRealLeft(dBox.evtTarget);
                targetY = getRealTop(dBox.evtTarget);                        
            }
                       
            $(dBox.box).css("left", targetX + (dBox.adjLeft) + 'px');
            $(dBox.box).css("top", targetY + (dBox.adjTop) + 'px');
        }           
    },
    
    showDBox : function(dBox, src)
    {
        if(dBox.bIsModal)
        {
            Newsweek.Widget.Overlay.init(dBox, src);
            return;
        }
        
        $(dBox.box).insertBefore("#nwContainer");
        $(dBox.box).fadeIn(250);
        this.hideDBox(dBox);
        
        $(window).resize(function(){
            
            Newsweek.Widget.DialogBox.resetCoord(dBox, src);
        });           
    },
       
    hideDBox : function(dBox)
    {           
        $(document).click(function(e){
        
            var mX = getMouseX(e);
            var mY = getMouseY(e);
            
           
            var dBoxHt = parseFloat($(dBox.box).height());
            var dBoxWt = parseFloat($(dBox.box).width());
            var dBoxTop = getRealTop(document.getElementById('dialog'));
            var dBoxLeft = getRealLeft(document.getElementById('dialog'));
            
            if((mY > (dBoxTop + dBoxHt) || mY < dBoxTop) || ((mX > (dBoxLeft + dBoxWt) || mX < dBoxLeft)) && $(dBox.box))
            {            
                $(dBox.box).fadeOut(function(){
                    
                    $(this).remove();
                    $(window).unbind("resize");
                    
                }, 250);
                
                Newsweek.Widget.DialogBox.isActive = false;
                $(document).unbind('click');                  
            }          
        });
    },
    
    showAd : function(dBox)
    {
		if(typeof(dBox.adCall) === 'function')
        {
            dBox.adCall();
        }
    }
}


Newsweek.Widget.TipStrip = {

    init : function()
    {
        $("#tipStripBox .content ul li a.next, #tipStripBox .content ul li a.prev").click(function(){
        
            var content = $("#tipStripBox .content");
            var link = $(this).attr("href");
            Newsweek.Widget.TipStrip.getAjaxRequest(content, link);    

            return false;
        });     
    },
    
    getAjaxRequest : function(content, link)
    {
        $.ajax({
           beforeSend : function()
           {
               $("ul li div", content).empty().append('<div class="loading"><span>Loading</span></div>'); 
           },
           url: detectProxy(link + "/output/ajaxtipstrip"),
           success:function(html) 
           {     
               $(content).html(html);          
               Newsweek.Widget.TipStrip.init();
               Newsweek.Widget.QuickRead();
           },
           error:function(e, msg)
           {
               $("ul li div", content).empty().append('<div class="ajaxErrorMsg">We are currently unable to return the requested content. Please try again later.</div>');          
           }
        }); 
    }
}


Newsweek.Widget.TravelHp = {
    
    init : function()
    {
        $("div.travelHp").each(function(i){
            
            var NwThp = this;
            
            NwThp = {
              
                isActive    : false,
                thp         : this,
                isOpen      : false,
                isCleared   : true,
                control     : [$("div.box div.content div.thpBut a.ctrl", this), $("div.thpTab div.tabBot a.ctrl", this)],
                content     : $("div.box div.content", this),
                scrollBut   : null,
                colWrapper  : $("div.box div.content div.thpColWrapper", this)
            }   
            Newsweek.Widget.TravelHp.controller(NwThp);              
        });            
    },

    controller : function(NwThp)
    { 

        $(NwThp.control).each(function(i){
            
            $(this).attr('href', rootpath + 'id/' + pid).click(function(){
                
                if($(this).attr("class") != 'ctrl' || $(this).attr('href') == '#'){return false;};   
                                
                if(!NwThp.isOpen && NwThp.isCleared)     
                {
                    $(this).removeAttr("class");
                }
                
                NwThp.isActive = true;
                NwThp.scrollBut = getRealTop(NwThp.thp);
                
                Newsweek.Widget.TravelHp.handlerThp(NwThp);
                
                return false;
            });                       
        
        });
    },
    
    handlerThp : function(NwThp)
    {
            
        if(NwThp.isOpen && !NwThp.isCleared)
        {
            var agent = navigator.userAgent.toLowerCase();
            
            if($(NwThp.thp).attr('id') == 'ThpBottom')
            {
                if(agent.indexOf('msie') == -1)
                {            
                    window.scrollTo(0, NwThp.scrollBut - 600);
                }
            } 
            
            agent = null;

            setTimeout(function(){
            
                Newsweek.Widget.TravelHp.shrinkThp(NwThp);
            
            }, 500);
        }
        else
        {                                   
            Newsweek.Widget.TravelHp.growThp(NwThp);
        }            
    },

    growThp : function(NwThp)
    {       
        var currDocHt = $(document).height();
             
        if(NwThp.isOpen && !NwThp.isCleared && !NwThp.isActive) {return;};
        
        $(NwThp.control).each(function(i){
            
            $(this).removeAttr("class");
        });        

        $(NwThp.thp).find(".thpButton").attr({
            src: Paths.Current.StaticContentRoot + "/site/images/thp_arrow_up.gif",
            alt: 'collapse'
        });
        
        $(".thpRgt, .thpMid, .thpLft", NwThp.colWrapper).hide();           
        
        $(NwThp.colWrapper).animate({
        
            height : 324 + 'px'
            
        }, 250, function(){
        
            $(NwThp.thp).find("div.tabBot").removeClass("thpDown").addClass("thpUp");                
            
            $(NwThp.thp).find(".thpTab div a img").attr({
                src: Paths.Current.StaticContentRoot + "/site/images/thp_close.gif",
                alt: 'collapse'                        
            });
            
            /*var dialog = document.getElementById('dialog')            
            var newDocHt = $(document).height();
            
            $(dialog).css('top', (getRealTop(dialog) + (newDocHt - currDocHt)) + 'px;')            */
        });
        
        setTimeout(function()
        {
            
            Newsweek.Widget.TravelHp.getContent(NwThp);
            
        }, 250);
    },
    
    getContent : function(NwThp)
    {    
        $(NwThp.colWrapper).css({
           width : "100%",
           clear : "both",
           margin : "0 0 0 -3px"    			           
        }); 
	     
	    var url = $(NwThp.control[0]).attr('href') + '/output/traveling' + '/sender/' + $(NwThp.thp).attr("id");
	     
        $.ajax({
           url      : detectProxy(url),
           success  : function(html) 
           { 
               $(NwThp.colWrapper).append(html);
               
               evalScripts(html);
               
                //Ad call
                $(travelingHomepageAdTarget()).insertBefore(NwThp.colWrapper);
                travelingHomepageAdCall();               
	           
               setTimeout(function(){
	           
                    $(NwThp.control).each(function(i){
                        
                        $(this).addClass("ctrl");
                    });			           
	           
               }, 1000);

               NwThp.isOpen = true;
               NwThp.isCleared = false; 
	           Newsweek.Widget.DynamicBox.init();  
           } 
        });
        url = null;     
    },
    
    shrinkThp : function(NwThp)
    {  
        var currDocHt = $(document).height();
    
        if(!NwThp.isOpen && NwThp.isCleared) {return;};
                
        if(NwThp.isOpen && !NwThp.isCleared)     
        {
            $(NwThp.control).each(function(i){
                
                $(this).removeClass("ctrl");
            });		
        }        
        
        $('.sponsoredAd', NwThp.content).remove();
        $("div.thpFeature", NwThp.content).empty();
        $("div.thpFeature", NwThp.content).remove();
        
        $(NwThp.colWrapper).animate({
        
            height: 37 + 'px'
            
        }, 100, function(){
        
            $("div.box div.content a img", NwThp.thp).attr({
                src: Paths.Current.StaticContentRoot + "/site/images/thp_arrow_down.gif",
                alt: 'expand'
            });        
           
            $("div div.tabBot", NwThp.thp).removeClass("thpUp").addClass("thpDown");
            
            $(NwThp.thp).find(".thpTab div a img").attr({
                src: Paths.Current.StaticContentRoot + "/site/images/thp_open.gif",
                alt: 'collapse'                        
            });
            
            $(NwThp.colWrapper).css({
                width : "934px",
                clear : "none",
                margin: "0px"
            
            });
           
            /*var dialog = document.getElementById('dialog')
            var newDocHt = $(document).height();
            
            $(dialog).css('top', (getRealTop(dialog) - (currDocHt - newDocHt)) + 'px;')*/
            
            $(".thpRgt, .thpMid, .thpLft", NwThp.colWrapper).show();                       
            
           evalScripts($(NwThp.colWrapper).html());
           
           setTimeout(function(){
           
                $(NwThp.control).each(function(i){
                    
                    $(this).addClass("ctrl");
                });			           
           
           }, 750);           
           
           
           NwThp.isCleared  = true;
           NwThp.isOpen = false;
                       
        });
    }
} 

Newsweek.Widget.QuickRead = function(link)
{
    $("a.quickRead").removeAttr("onclick");
   
    Newsweek.Widget.DialogBox.init('quickread', link, 'a.quickRead', '', quickReadAdCall, {"bIsModal" : true, "bIsScrollable" : true, "bIsCentered" : true});    
}

Newsweek.Widget.QuickGuide = function()
{
    $("a.quickGuide").css({visibility : 'visible'});
    Newsweek.Widget.DialogBox.init('quickGuide', '', 'a.quickGuide', '', quickGuideAdCall, {"bIsModal" : true, "adjLeft" : -546, "adjTop" : 10});    
}

Newsweek.Widget.SocialNetwork = function()
{
    $('.socialNetworks').click(function(e){
    
        if(Newsweek.Widget.DialogBox.isActive) {return;};   
    
        var html = $(".SocialLinksDiv").html();
        Newsweek.Widget.DialogBox.init('', '', '', html, '', {"adjLeft" : 100, "adjTop" : -40}, e.target);  
        
        return false;    
    });
}

Newsweek.Widget.Login = {

    init : function()
    {
        $('#login').click(function(e){
                       
            Newsweek.Widget.DialogBox.init('', '', '', $("#loginFormDiv").html(), '', {"bIsModal" : true,  "adjLeft" : -370, "adjTop" : -1}, e.target);
            Newsweek.Widget.Login.validate();
            $("#loginForm input[@name='ReturnUrl']").val(location.href);
            return false;
        });      
    },
    
    validate : function()
    {
        $("#loginForm").validate({
		
          errorPlacement: function(error, element) {
            error.insertAfter(element.parent("span").siblings("label"))
          },          
          errorClass: "invalid",              
		        event: "submit",
		        wrapper: "span",
		        rules: {
			          username: {
				          required: true
			          },
			          password: {
				          required: true
			          }
		        },
		        messages: {
			          username: {
				            required: 'Please enter your username'
			          },
			          password: {
				            required: 'Please enter a password'
			          }
		        }
	      });        
    }
}

Newsweek.Widget.MMToolBar = {

    isInitSocial : false,
    isOpenSocial : false,
    
    init : function()
    {
        $(document).click(function(e){
        
            if(e.target.getAttribute('class') != 'SocialNetworks');
            {
                Newsweek.Widget.MMToolBar.closeSocialBox();
                return;
            }
        });
        
        $(".socialNetworks").click(function(e){

            Newsweek.Widget.MMToolBar.isInitSocial = true;
            Newsweek.Widget.MMToolBar.openSocialBox(this);
            
            return false;
        });    
    },
    
    openSocialBox : function(link)
    {
        if(this.isOpenSocial) {
            this.closeSocialBox();
            return;
        };
    
        this.isInitSocial = true;
        
        var left = getRealLeft(link);
        var top = getRealTop(link);
        
        
        $("#ShareLinks").css("left", left - 147 + "px").slideDown(250, function(){
        
            Newsweek.Widget.MMToolBar.isOpenSocial = true;
            
        });
    },
    
    closeSocialBox : function()
    {
        if(!this.isInitSocial && !this.isOpenSocial) {return;};
        
        $("#ShareLinks").slideUp(250, function(){
        
            Newsweek.Widget.MMToolBar.isOpenSocial = false;
            Newsweek.Widget.MMToolBar.isInitSocial = false;
            
        });
    }
} 

Newsweek.Widget.DynamicBox = {

    init : function()
    {
       $('.flipper .middle .controls div a.prev, .flipper .middle .controls div a.next').click(function(){
       
            var content = $(this).parents('div.box').slice(0,1).children('div.content').slice(0, 1);
            var id = $(this).attr('href');
            var nav = $(this).parent().parent('div.controls');            
            Newsweek.Widget.DynamicBox.getAjaxRequest(content, id, nav);
            
            //var scroll = getRealTop($(this).parents('div.BoxCollection').get(0));
            //if (typeof(scroll) != 'undefined' && scroll > 0) window.scrollTo(0, scroll);
            
            return false;
        });
    },
    
    getAjaxRequest : function(content, id, nav)
    {
        $.ajax({
           beforeSend : function()
           {
                $(content).html('<div class="loading peekld"><span>Loading</span></div>');
           },
           dataType : 'html',
           url: detectProxy(id + '/output/AjaxBox'),
           success:function(html) 
           {  
              $(content).html($(html).children('div').slice(0, 1).html());
              $(nav).html($(html).children('div').slice(1, 2).html());
              evalScripts(html);
	          Newsweek.Widget.QuickRead();
	          Newsweek.Widget.DynamicBox.init();      
	       } 
        }); 
        
        return false;    
    }
}

Newsweek.Widget.BoxCollections = {

    init : function()
    {
        $('.BoxCollection').each(function() {
	        new BoxCollection(this);
        });	    
    }
}

Newsweek.Widget.Comments_Reply = {

    isInitReply : false,
    source      : '',
    textVal     : '',
    replyId     : '',

    init : function()
    { 
        $("a.reply").click(function(){
           
            if(Newsweek.Widget.Comments_Submit.isActive){return;};            
            
            Newsweek.Widget.Comments_Reply.replyId = parseFloat(this.id);            
            Newsweek.Widget.Comments_Reply.source = this;
            Newsweek.Widget.Comments_Reply.getForm();
            
            return false;
        });      
    },
    
    getForm : function()
    {
        var reportTop = $(this.source).parent().siblings(".postContent").height() + parseFloat(getRealTop(this.source)) + 15;
        var reportLeft = getRealLeft(document.getElementById('nwComments')) + 6;
        
        Newsweek.Widget.DialogBox.init('', '', '', $("#replyFormDiv").html(), '', {"bIsModal" : true, "adjLeft" : reportLeft, "adjTop" : reportTop});
        
        $("#replyField").focus(function(){
            if($(this).val() == 'Enter Your Comment')
            {
                $(this).val('')
            }
        });

        $("#replyToId").val(this.replyId);                                
		$("#replyForm input[@name='ReturnUrl']").val(location.href);
        Newsweek.Widget.Comments_Submit.form = $("#replyForm");        
        Newsweek.Widget.Comments_Submit.init();       
    },  
    
    resetForm : function()
    {
        $("a.closeModal, #overlay2").click(function(){
            if($("#replyBox"))
            {
                $("input[@name = 'replyToId']").val('-1');
                $("#articleCommentForm").slideDown(250);                                
            }
            
            Newsweek.Widget.Comments_Submit.init(); 
            return false;
        });
    }
}

Newsweek.Widget.Comments_Report = {
    
    isInitNwReport : false,
    reportId : '',
    source : '',
    
    init : function()
    {
        $("a.report").click(function(){
           
            if(Newsweek.Widget.Comments_Submit.isActive){return;};                       

            Newsweek.Widget.Comments_Report.reportId = parseFloat(this.id);                     
            Newsweek.Widget.Comments_Report.source = this;
            Newsweek.Widget.Comments_Report.getForm(); 
            
            return false;        
        });    
    },
    
    getForm : function()
    {
        var reportTop = $(this.source).parent().siblings(".postContent").height() + parseFloat(getRealTop(this.source)) + 15;
        var reportLeft = getRealLeft(document.getElementById('nwComments')) + 6;
        
        Newsweek.Widget.DialogBox.init('', '', '', $("#abuseFormDiv").html(), '', {"bIsModal" : true, "adjLeft" : reportLeft, "adjTop" : reportTop});             
       
        $("#reportField").focus(function(){
        
            if($(this).val() == 'Report Abuse')
            {
                $(this).val('')
            }
        });
        
        $("#reportPostId").val(Newsweek.Widget.Comments_Report.reportId);          
                         
        Newsweek.Widget.Comments_Submit.form = $("#abuseForm");
        Newsweek.Widget.Comments_Submit.init();       
    }   
}

Newsweek.Widget.Comments_Submit = {
    
    form : null,
    msg : null,
    isActive : false,
    successMsg : function()
    {
        if($(this.form).attr('id') == 'replyForm')
        {
            return 'Your reply has been successfully submitted.  It may take a few minutes for it to appear.';
        }
        else if($(this.form).attr('id') == 'abuseForm')
        {
            return 'Your report has been successfully submitted.';
        }
        else
        {
            return 'Your comment has been successfully submitted.  It may take a few minutes for it to appear.';
        }
    },
    
    errorMsg : function()
    {
        if($(this.form).attr('id') == 'replyForm')
        {
            return 'Your reply could not be submitted at this time. Please try again later.';
        }
        else if($(this.form).attr('id') == 'abuseForm')
        {
            return 'Your report could not be submitted at this time. Please try again or contact Newsweek.com';
        }
        else
        {
            return 'Your comment could not be submitted at this time. Please try again later.';
        }    
    },
     
    init : function()
    {   
    
        if($("#commentForm").siblings("span.message").text() != '' && $("#commentForm").siblings("span.message").text() != ' ')
        {
            this.isActive = true;
            this.isRedirect();
            return;
        }
    
        if(this.isActive){return;};
        
        $(this.form).find("textarea").focus(function(){
            
            if($(this).val() == 'Enter Your Comment')
            {
                $(this).val('')
            }
            
        });        
                
        var handleForm = {
        
            //dataType : 'xml',
            
            beforeSubmit : function(formData, e)
            {            
		        if(!Newsweek.Widget.Comments_Submit.validatePost())
		        {
		            return false;
		        }	            
   
                Newsweek.Widget.Comments_Submit.isActive = true;
                
                $("#overlay2, .closeModal").unbind("click");
                $("<span class='loading2'></span>").insertBefore($(Newsweek.Widget.Comments_Submit.form).siblings("h5"));
                $(Newsweek.Widget.Comments_Submit.form).find("input:submit").attr("disabled", "disabled");
                $("fieldset textarea", Newsweek.Widget.Comments_Submit.form).attr("disabled", "disabled").css("background", "#f5edc9");
            },
            	    
            success : function(responseText) {
            
                var errorCode = $(responseText).children().children().children().children().children("ErrorCode").text();
                if(errorCode != "" & errorCode == 0) 
                {   
                    $(Newsweek.Widget.Comments_Submit.msg).text(Newsweek.Widget.Comments_Submit.successMsg());                    

                    $(".loading2").fadeOut(400).remove();   
                    
                    setTimeout(function(){     
                                   
                        $("fieldset textarea", Newsweek.Widget.Comments_Submit.form).removeAttr("disabled").css("background", "#fff").val('Enter Your Comment');
                        
                        Newsweek.Widget.Comments_Submit.form = $("#commentForm");
                        
                        if($("#dialog"))
                        {   
                            Newsweek.Widget.Overlay.hideOverlay();
                        }
                       
                        $(Newsweek.Widget.Comments_Submit.msg).html(''); 
                        
                        Newsweek.Widget.Comments_Submit.resetForm();
                            
                                    
                    }, 5000);
                }
                else
                {
                    Newsweek.Widget.Comments_Submit.proxyErr();
                    return;                
                }
                                
                return false;
                
            },
            
            error : function(request, msg, e)
            { 
                Newsweek.Widget.Comments_Submit.proxyErr();
            }
        }
        
        if((typeof isAuthenticated != 'undefined' && isAuthenticated) | $(this.form).attr('id') == 'abuseForm') {    
	        
			$(this.form).ajaxForm(handleForm);   
		}
		else
		{
		    if(typeof document.commentForm != 'undefined') {
			    $("#commentForm input[@name='ReturnUrl']").val(location.href);
		    }
		    
		    $(this.form).submit(function(){
		    
		        if(!Newsweek.Widget.Comments_Submit.validatePost())
		        {
		            return false;
		        }		    
		    });
		}                       
    },
    
    validatePost : function()
    {
        Newsweek.Widget.Comments_Submit.msg = $(Newsweek.Widget.Comments_Submit.form).siblings("span.message");
    
        if($("fieldset textarea", Newsweek.Widget.Comments_Submit.form).val().length > 3000)
        {               
            $(Newsweek.Widget.Comments_Submit.msg).text('Please enter up to 3000 characters.').slideDown(250);
            
            return false;
        }
        else if($.trim($("fieldset textarea", Newsweek.Widget.Comments_Submit.form).val()) == 'Enter Your Comment' || $("fieldset textarea", Newsweek.Widget.Comments_Submit.form).val() == '')
        {
            $(Newsweek.Widget.Comments_Submit.msg).text('Please enter a comment.').slideDown(250);
            
            return false;
        }
        
        return true;    
    },
    
    proxyErr : function(msg)
    {
        $(Newsweek.Widget.Comments_Submit.msg).css("color", '#bf1b02').text(Newsweek.Widget.Comments_Submit.errorMsg()).fadeIn(function(){
       
             $(".loading2").fadeOut(400).remove();   
        });
        
        setTimeout(function(){
            
            $("fieldset textarea", Newsweek.Widget.Comments_Submit.form).removeAttr("disabled").css("background", "#fff");
            
            if(document.getElementById('dialog'))
            {                  
                Newsweek.Widget.Overlay.hideOverlay();
            }
            
            $(Newsweek.Widget.Comments_Submit.msg).text('');             
            
            Newsweek.Widget.Comments_Submit.resetForm();            
            
        }, 5000);
    },
    
    resetForm : function()
    {
        $("#reportField, #replyField, #commentField").focus(function(){
        
            if($(this).val() == 'Enter Your Comment' || $(this).val() == 'Report Abuse')
            {
                $(this).val('');
            }
        });
                    
        $(Newsweek.Widget.Comments_Submit.form).find("input:submit").attr("disabled", false);
        Newsweek.Widget.Comments_Submit.isActive = false;                
    },
    
    isRedirect : function()
    {
        setTimeout(function(){
            $("#commentForm").siblings("span.message").text('');
            $("#commentForm fieldset textarea").removeAttr("disabled").css("background", "#fff");
            $("#commentForm input:submit").removeAttr("onclick");
            Newsweek.Widget.Comments_Submit.isActive = false;               
            Newsweek.Widget.Comments_Submit.init();         
        }, 5000)
    }
}


function EmailArticle_RequiredExist()
{
    var YourName = document.getElementById("EmailYourName");
    var YourEmailAddress = document.getElementById("EmailYourEmailAddress");
    var RecEmailAddress = document.getElementById("EmailRecEmailAddress");
    var Message = document.getElementById("EmailMessage");

    if (YourName.value.length == 0)
    {
        EmailArticle_ShowError("Please enter Your Name before sending.", YourName);
        return false;
    }

    if (YourEmailAddress.value.length == 0)
    {
        
        EmailArticle_ShowError("Please enter Your Email Address before sending.", YourEmailAddress);
        return false;
    }
    else
    {
        if (!IsValidEmailAddress(YourEmailAddress.value))
        {
            EmailArticle_ShowError("Your Email Address is not valid.  Please enter something different.", YourEmailAddress);
            return false;
        }
    }

    if (RecEmailAddress.value.length == 0)
    {
        EmailArticle_ShowError("Please enter the Recipient's Email Address before sending.", RecEmailAddress);
        return false;
    }
    else
    {
        if (!IsValidEmailAddresses(RecEmailAddress.value))
        {
            EmailArticle_ShowError("At least one of the Recipient's Email Addresses is not valid.  Please enter something different.", RecEmailAddress);
            return false;
        }
    }

    return true;
}

function IsValidEmailAddress(Value)
{
    return RegexValidate(Value, "^([a-zA-Z0-9_\\-\\.]+)@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.)|(([a-zA-Z0-9\\-]+\\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\\]?)$");
}

function IsValidEmailAddresses(value)
{
    var addresses = value.split(",");

    for (var a = 0; a < addresses.length; a++)
    {
        var address = StringTrim(addresses[a]);

        if (address.length > 0)
        {
            if (!IsValidEmailAddress(address))
            {
                return false;
                break;
            }
        }
    }

    return true;
}

function RegexValidate(Value, Pattern)
{
    if (Pattern != null && Pattern.length > 0)
    {
        var re = new RegExp(Pattern);

        return Value.match(re);
    }
    else
    {
        return false;
    }
}

function StringTrim(value)
{
    value = value.replace( /^\s+/g, "");
    return value.replace( /\s+$/g, "");
}

function EmailArticle_ShowError(Message, Control)
{
    $("#EmailErrorMessage").show().html(Message)
    Control.focus();
}

Newsweek.Widget.EmailArticle = {       
    
    source : '',
    
    init : function()
    {
        var html = $("div.EmailArticleBlock").html();        
        
        $(".emailArticleLink").click(function(){
            
            Newsweek.Widget.EmailArticle.source = this;      
            Newsweek.Widget.EmailArticle.showForm(html);
            
            return false;
        });
    },
    
    showForm : function(html)
    {    
        var emailSourceTop = parseFloat(getRealTop(this.source)) - 101;
        var emailSourceLeft = parseFloat(getRealLeft(this.source)) + 53;
    
        Newsweek.Widget.DialogBox.init('', '', '', html, '', {"bIsModal" : true, "adjLeft" : emailSourceLeft, "adjTop" : emailSourceTop});      
        this.submitForm();   
    },
    
    submitForm : function()
    {        
        var emailArticle = {
            
            beforeSubmit : function(formData)
            {
                EmailArticle_RequiredExist();
                
                if(EmailArticle_RequiredExist())
                {                    
                    $(".emailArticleForm :input").slice(0, 3).attr("disabled", "true");
                    $("#EmailPersonalMessage").attr("disabled", "disabled");
                    $("#EmailMain").height(186 + 'px');
                    $("#EmailMain p").slice(0, 1).text("Sending email now...");
                    //$("<div class='loading2' style='height:36px;width:30px;'><span>&nbsp;<span/></div>").insertBefore($("#EmailMain h2"));              
                }
                else
                {
                    return false;
                }
            },
            	    
            success: function(msg)
            {
                $("#EmailMain p").slice(0, 1).addClass("success").text(msg);
                $("#EmailMain div.loading2").remove();
                
                setTimeout(function(){
                    
                    Newsweek.Widget.Overlay.hideOverlay();        
                    
                }, 5000);
            },
            
            error : function(request, msg, e)
            {
                $("#EmailMain p").slice(0, 1).addClass("error").text(msg);
                $("#EmailMain div.loading2").remove();
                
                setTimeout(function(){
                    
                    Newsweek.Widget.Overlay.hideOverlay();        
                    
                }, 5000);               
            }            
        }
        
        $("#frmEmailThisArticle").ajaxForm(emailArticle);        
    }
}    
