﻿// NW Utilities
// Author(s): Nehal Shah, Paul Waldschmidt, Michael Trythall, David Johnson
// Version: 1.0
// Created: 9/11/2007
// Updated: 10/9/2007


$.fn.center = function(f) {
    return this.each(function(){
        if ( !f && this.nodeName == 'DIV' &&
                 !this.offsetWidth && !this.offsetHeight ) {
            var self = this;
            setTimeout(function(){
                $(self).center(true);
            }, 13);
        } else {
            var s = this.style;
            var p = this.parentNode;
            if ( $.css(p,"position") == 'static' ) {
                p.style.position = 'relative';
            }
            s.position = 'absolute';
            s.left = (($.css(p,"width") - $.css(this,"width"))/2) + "px";
            var scroll = getScrollTop();
            s.top = (scroll + 180) + "px";
            //s.top = ((200 - $.css(this,"height"))/2) + "px";
        }
    });
};

function getDocWidth()
{
    var docWidth = 0;
    
    if (window.innerWidth || window.innerHeight){ 
        docWidth = window.innerWidth; 
    } 
    
    if (document.body.clientWidth || document.body.clientHeight){ 
        docWidth = document.body.clientWidth; 
    } 
    
    return docWidth;
}

function getDocHeight()
{
    /* Gets the entire height of a document */
    var docHeight = 0;
    if(document.body.offsetHeight)
    {
        docHeight = document.body.offsetHeight;
    }
    else
    {
        docHeight = document.body.scrollHeight;
    }
    
    return docHeight;
}


function m(e, anchorObj, targetObj)
{
	var yoff = 0;
	var xoff = 0;
	var anchorEl = anchorObj;

	if(el && targetObj == null)
	{
		moveToMouse(e, anchorEl, xoff, yoff);
	}
	else
	{
	    moveToObj(anchorEl, targetObj, xoff, yoff);
	}
}

function moveToObj(anchorEl, targetObj, xOff, yOff)
{
	// Moves an element to another element via mouse event
	xPos = $(div).css("left", xOff + "px");
	yPos = $(div).css("top", yOff + "px");
	
	move(targetObj, xPos, yPos);
}

function moveToMouse(e, el, xScrollLeft, yScrollTop)
{
	// Moves an element to the position of the mouse
	xPos = getPointerX(e);
	yPos = getPointerY(e);
    
	move(el, (yPos + yScrollTop), (xPos + xScrollLeft));
}


function getPointerX(e)
{  
	return ((e != null) ? e.pageX : getMouseX(window.event));
}

function getPointerY(e)
{  
	return ((e != null) ? e.pageY : getMouseY(window.event));
}

function move(el, left, top)
{
	// Moves an element vertically and horizontally
	el.style.top =  top + "px";
	el.style.left = left + "px"; 
}

// returns left position of an element w/o offset
function getRealLeft(div)
{
	thisObj = div;
	xPos = getRealLeftByObj(div);
	return xPos;
}

// returns top position of an element w/o offset
function getRealTop(div)
{
	thisObj = div;
	yPos = getRealTopByObj(div);
	return yPos;
}

// returns true top position of an element
function getRealTopByObj(thisObj)
{
	yPos = 0;
	if(thisObj)
	{
		yPos = thisObj.offsetTop;
		tempEl = thisObj.offsetParent;
		while(tempEl != null)
		{
			yPos += tempEl.offsetTop;
			tempEl = tempEl.offsetParent;
		}
	}
	return yPos;
}

// returns true left position of an element
function getRealLeftByObj(thisObj)
{
	xPos = 0;
	if(thisObj)
	{
		xPos = thisObj.offsetLeft;
		tempEl = thisObj.offsetParent;
		while(tempEl != null)
		{
			xPos += tempEl.offsetLeft;
			tempEl = tempEl.offsetParent;
		}
	}
	return xPos;
}

// Returns mouse Y Position 
function getMouseY(e)
{
    if(e == null){e = event};
	
	return e.clientY + document.documentElement.scrollTop; // true yPos mouse event, exclusive to ie
}

// Returns mouse X Position
function getMouseX(e)
{
    if(e == null){e = event};
    
	return e.clientX + document.documentElement.scrollLeft; // true xPos mouse event, exclusive to ie
}

// Returns scroll top
function getScrollTop() 
{
	if (document.documentElement && document.documentElement.scrollTop)
	{
		return document.documentElement.scrollTop;
	}
	else if (document.body)
	{
		return document.body.scrollTop;
	}
	else if (window.pageYOffset)
	{
		return window.pageYOffset;
	}
	return 0;
}

// Adds an event handler to the source
function AddHandler(eventSource, eventName, handlerName, eventParent) {
    var eventHandler = function(e) {eventSource[handlerName](e, eventParent);};

    if (eventSource.addEventListener)
    {
        eventSource.addEventListener(eventName, eventHandler, false);
    }
    else if (eventSource.attachEvent)
    { 
        eventSource.attachEvent("on" + eventName, eventHandler);
    }
    else
    {
        var originalHandler = eventSource["on" + eventName];

        if (originalHandler)
        {
            eventHandler = function(e) {originalHandler(e); eventSource[handlerName](e, eventParent);};
        }

        eventSource["on" + eventName] = eventHandler;
    }
}

// Returns the coordinates of and element
function GetEventXY(e){
    var x, y;

    if (!e) var e = window.event;
    if (document.all){

        x = e.clientX + document.body.scrollLeft;
        y = e.clientY + document.body.scrollTop;
    } else {
        x = e.pageX;
        y = e.pageY;
    }

    if (x < 0){
        x = 0;
    }

    if (y < 0){
        y = 0;
    }

    return [x, y];
}

//Returns the true offset position of an element
function GetPos(Obj) {
	var curleft = curtop = 0;

	if (Obj.offsetParent)
	{
		curleft = Obj.offsetLeft;
		curtop = Obj.offsetTop;

		while (Obj == Obj.offsetParent)
		{
			curleft += Obj.offsetLeft;
			curtop += Obj.offsetTop;
		}
	}

	return [curleft, curtop];
}

function evalScripts(html)
{
	var re = /<script.*?>([\s\S]*?)<\//igm;
	var match;
	while (match = re.exec(html)) {
		eval(match[1]);
	}
}

/* cache background images [IE Fix] */
try 
{
    document.execCommand("BackgroundImageCache", false, true);
} 
catch(err) {}

function toggleWindowObjects(show) {
    if (show) {
        $("select").css('visibility', 'visible');
        $("object").each(function() {
			var html = $(this).html().toLowerCase();
			if (html.indexOf('name="wmode" value="transparent"') == -1 && html.indexOf('name="wmode" value="opaque"') == -1) {
				$(this).css('visibility', 'visible');
			}
		});
        $("embed[@wmode != 'transparent']").css('visibility', 'visible');
        $("embed[@wmode != 'opaque']").css('visibility', 'visible');
    }
    else {
        $("select").css('visibility', 'hidden');
        $("object").each(function() {
			var html = $(this).html().toLowerCase();
			if (html.indexOf('name="wmode" value="transparent"') == -1 && html.indexOf('name="wmode" value="opaque"') == -1) {
				$(this).css('visibility', 'hidden');
			}
		});
        $("embed[@wmode != 'transparent']").css('visibility', 'hidden');
        $("embed[@wmode != 'opaque']").css('visibility', 'hidden');
    }
}

var arrNodeClass = new Array('peekOff', 'peekSelected', 'ctrl', 'thpButton', 'quickGuide', 'next', 'prev');
disableContextMenu(arrNodeClass);

function disableContextMenu(ctrlClass)
{   
    document.oncontextmenu = function(e){
 
        if(!e) e = window.event;
        
        var evtTarget = (e.target) ? e.target : e.srcElement;
        
        for(var i=0;i<ctrlClass.length;i++)
        {   
            if(evtTarget.className.indexOf(ctrlClass[i]) != -1 || evtTarget.parentNode.className.indexOf(ctrlClass[i]) != -1)
            {
                return false;
                evtTarget = null;
            }        
        }
    }
}