package info.collide.coolmodes.palettes.calc;

import java.awt.*;
import java.awt.geom.*;
import javax.swing.*;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

import com.spiriteam.naming.*;
import com.spiriteam.graph.*;

import info.collide.xml.*;

public class SubtractionEdge extends StyledEdge {
    /* the actual component, displayed by the help of an EdgeComponent */
    private JLabel label;
    /* this array will be returned in our overridden getEdgeComponents() method */
    private EdgeComponent[] edgeComponents = new EdgeComponent[1];
    
    public SubtractionEdge(){
        this(new SubtractionEdgeModel());
    }
    
    public SubtractionEdge(SubtractionEdgeModel model) {
        super(model);
        initView();
    }
    
    public SubtractionEdge(Node node1,Node node2) {
        this(new SubtractionEdgeModel(node1.getID(), node2.getID()));
    }
    
    public SubtractionEdge(boolean createModel) {
      super(false);
      if (createModel)
          model = new SubtractionEdgeModel();
  }
    
    public void initView() {
        super.initView();
         try {
            ImageIcon img;
            img = new ImageIcon(ClassLoader.getSystemClassLoader().getResource("info/collide/coolmodes/palettes/calc/resources/minus.gif"));
            this.label=new JLabel(img);
            edgeComponents[0] = new EdgeComponent(label, 0.5, 0);
        }
        catch (NullPointerException npe) {}
    }
    
    public EdgeComponent[] getEdgeComponents() {
        return edgeComponents;
    }
}