package info.collide.coolmodes.palettes.calc;

import com.spiriteam.popup.*;
import com.spiriteam.graph.*;

import info.collide.locale.*;

import java.util.*;

public class ResetInput extends PopupAction {
    
    //public static String name = "Reset input";
    protected static CalcProp prop;
   
    public ResetInput() {
        super(new info.collide.locale.LocalizedMessage(prop.getProp("input.popup.resetinput", Locale.ENGLISH), 
            prop.getProp("input.popup.resetinput", Locale.GERMAN), 
            prop.getProp("input.popup.resetinput", new Locale("es"))
            ));
    }
    
    public void graphAction(PopupEvent e) {
        Vector nodes = jgraph.getNodeVector();
        for (int i = 0; i < nodes.size(); i++)
            if (nodes.get(i) instanceof InputNode)
                ((InputNode)nodes.get(i)).setValue(0);
    }
    
    public void nodeAction(PopupEvent e) {
        if (node instanceof InputNode)
            ((InputNode)node).setValue(0);
    }
    
    public void strokeAction(PopupEvent e) {}
    
}

