package info.collide.coolmodes.palettes.calc;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import com.spiriteam.graph.*;

public class OutputNodeView extends AbstractView {

    public static final Font DEFAULT_FONT=new Font("SansSerif",Font.BOLD,12);

    private JTextField textField, valueField;

    public OutputNodeView()
    { this("",0); }

    public OutputNodeView(String text, int value)
    { this(text,value,true); }

    public OutputNodeView(String text, int value, boolean editable) {
        textField=new JTextField(text);
        textField.setBackground(Color.magenta.brighter());
        textField.setBorder(null);
        valueField=new JTextField(Integer.toString(value));
        if (!editable)
            textField.setEditable(false);
        valueField.setEditable(false);
        setLayout(new BoxLayout(this,BoxLayout.Y_AXIS));
        add(textField);
        add(valueField);
        setBackground(Color.magenta.brighter());
    }

    public void paintWithGrip(Graphics2D g) {
        g.setColor(getBackground());
	g.fillRect(0, 0, (int)getSize().getWidth(), (int)getSize().getHeight());
    }

    public void paintWithoutGrip(Graphics2D g) {
        g.setColor(getBackground().darker());
	g.setStroke(new BasicStroke(2.0f));
	g.drawRect(1, 1, (int)getSize().getWidth()-2, (int)getSize().getHeight()-2);
    }

    public void addKeyListener(KeyListener l) {
        textField.addKeyListener(l);
    }

    public void addChangeListener()
    {}

    public void setText(String text) {
        this.textField.setText(text);
    }

    public void setValue(String valueString) {
        this.valueField.setText(valueString);
    }

    public String getText()
    { return textField.getText(); }

    public int getValue()
    { return new Integer(valueField.getText()).intValue(); }

    public void setValue(int val)
    { valueField.setText(Integer.toString(val)); }

    public Insets getInsets()
    { return new Insets(8,8,8,8); }
}
