package mypalettes.calc;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

public class OutputNodePanel extends JPanel {
    
    public static final Font DEFAULT_FONT=new Font("SansSerif",Font.BOLD,12);
    
    private JTextField textField, valueField;
    
    public OutputNodePanel()
    { this("",0); }
    
    public OutputNodePanel(String text, int value)
    { this(text,value,true); }
    
    public OutputNodePanel(String text, int value, boolean editable) {
        textField=new JTextField(text);
        textField.setBackground(Color.magenta.brighter());
        textField.setBorder(null);
        valueField=new JTextField(Integer.toString(value));
        if (!editable)
            textField.setEditable(false);
        valueField.setEditable(false);
        setLayout(new BoxLayout(this,BoxLayout.Y_AXIS));
        add(textField);
        add(valueField);
        setBackground(Color.magenta.brighter());
    }
    
     public void addKeyListener(KeyListener l) {
        textField.addKeyListener(l);
    }
    
    public void addChangeListener()
    {}
    
    public void setText(String text) {
        this.textField.setText(text);
    }
    
    public void setValue(String valueString) {
        this.valueField.setText(valueString);
    }
    
    public String getText()
    { return textField.getText(); }
    
    public int getValue()
    { return new Integer(valueField.getText()).intValue(); }
    
    public void setValue(int val)
    { valueField.setText(Integer.toString(val)); }
    
    public Insets getInsets()
    { return new Insets(8,8,8,8); }
}
