package info.collide.coolmodes.palettes.calc;

import com.spiriteam.naming.*;
//import com.spiriteam.graph.*;

import org.w3c.dom.*;

import java.io.*;

public class OutputNodeModel extends CalcNodeModel implements Serializable
{
    
    public OutputNodeModel()
    {
        this(OutputNode.DEFAULT_TEXT, OutputNode.DEFAULT_VALUE);
    }
    
    public OutputNodeModel(UniqueID id) {
        super(id);
    }
    
    public OutputNodeModel(String str,int val,UniqueID id) 
    {
        super(str, val, id);
    }
    
    public OutputNodeModel(String str, int val) {
        super(str, val);
    }
    
    /* we don't read the node's value from the XML file, but instead create the model with a value of 0 because when the JGraph
     * is being created with all the nodes and edges the edgeAdded() method of our node is called so that it gets the correct
     * value. If we had set the value before, the node would now have twice its actual value.
     */
    public void configureByXML(Element element) {
        super.configureByXML(element);
        setText(element.getAttribute("text"));
    }
    
}
