package info.collide.coolmodes.palettes.calc;

import java.awt.*;
import java.util.*;
import java.awt.event.*;

import javax.swing.*;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

import com.spiriteam.graph.*;
import com.spiriteam.graph.event.*;
import com.spiriteam.sync.*;

import info.collide.xml.*;
import info.collide.locale.*;

public class OutputNode extends AbstractNode implements NodeListener, KeyListener, LocaleListener {
    
        
    public static final String DEFAULT_TEXT="Output val.";
    public static final int DEFAULT_VALUE=0;
    
    private Hashtable termsOfSum = new Hashtable();
    
    private OutputNodeView view;
    
    protected CalcProp prop;

    public OutputNode() {
               this(new OutputNodeModel());     
    }

    public OutputNode(OutputNodeModel model) {
        super(model);
        ((CalcNodeModel)model).setValue(0);
        initView(); 
    }
    
    public OutputNode(boolean createModel) {
        super(false); 
        if (createModel)
            model = new OutputNodeModel();
    }
    
    public void initView() {
        view=new OutputNodeView(((OutputNodeModel)model).getText(),((OutputNodeModel)model).getValue());
        view.setFont(OutputNodeView.DEFAULT_FONT);
        view.addKeyListener(this); 
        LocaleManager.getLocaleManager().addLocaleListener(this);
        updateBorder(); 
    }
    
    private void changeLanguage(java.util.Locale oldLocale) {
        if (!((CalcNodeModel)model).getText().equals(prop.getProp("output.defaultname", oldLocale))) {
            return;
        }
        ((CalcNodeModel)model).setText(prop.getProp("output.defaultname"));
        view.setText(((CalcNodeModel)model).getText());
        //fireChangeEvent();
        if (getClient()!=null)
            getClient().changeObject(getLabel(),(java.io.Serializable)getModel(),false);
    }
   
    /* Returns the panel the user is interacting with. */
    public JComponent getUI()
    { return view; }
    
    // SyncListener implementation: //

    public void objectChanged(SyncEvent evt) {
        OutputNodeModel model=(OutputNodeModel)evt.getObject();
        ((OutputNodeModel)this.model).setText(model.getText());
        view.setText(model.getText());
    }
    
    
    
    public void objectCreated(SyncEvent event){}
    
    public void objectDeleted(SyncEvent evt) {}
    
    public void actionExecuted(SyncActionEvent event){}
    
    
    
    // NodeListener implementation: //

    /* if an AdditionEdge or SubtractionEdge was added to our node, we accordingly change the value in our model and the view. It is not
     * necessary to notify Matchmaker of the model change, since in the synchronized JGraphs, the edgeAdded() method will also be called.     
     * We do however fire a local change event to inform other OutputNodes that we point to with an AdditionEdge or SubtractionEdge 
     * of the change.
     */
    public void edgeAdded(NeighborEvent e) { 
        if (e.getEdge() instanceof AdditionEdge) {
            AdditionEdge newEdge=(AdditionEdge)e.getEdge();
            if (newEdge.getTo().equals(this)) {
                int v=((OutputNodeModel)model).getValue();
                Node newNode=e.getNode();
                int d=0;
                if (newNode instanceof InputNode || newNode instanceof OutputNode)
                    d=((CalcNodeModel)newNode.getModel()).getValue();
                v = v + d;
                termsOfSum.put(newNode.getID(), new Integer(d));
                ((OutputNodeModel)model).setValue(v);
                view.setValue(v);
                fireChangeEvent();
            }
        }
        
        else if (e.getEdge() instanceof SubtractionEdge){
            SubtractionEdge newEdge=(SubtractionEdge)e.getEdge();
            if (newEdge.getTo().equals(this)) {
                int v=((OutputNodeModel)model).getValue();
                Node newNode=e.getNode();

                int d=0;                
                if (newNode instanceof InputNode || newNode instanceof OutputNode)
                    d=((CalcNodeModel)newNode.getModel()).getValue();
                v = v - d;
                termsOfSum.put(newNode.getID(), new Integer(d));
                ((OutputNodeModel)model).setValue(v);
                view.setValue(v);
                fireChangeEvent();
            }
        }
        //fireChangeEvent();
    }
    
    
    
    /* if an AdditionEdge or SubtractionEdge was removed from our node, we accordingly change the value in our model and the view. It is not
     * necessary to notify Matchmaker of the model change, since in the synchronized JGraphs, the edgeRemoved() method will also be called.     
     * We do however fire a local change event to inform other OutputNodes that we point to with an AdditionEdge or SubtractionEdge
     * of the change.     
     */
    public void edgeRemoved(NeighborEvent e) { 
        StyledEdge oldEdge = null;
        if (e.getEdge() instanceof AdditionEdge)
            oldEdge=(AdditionEdge)e.getEdge();
        else if (e.getEdge() instanceof SubtractionEdge)   
            oldEdge = (SubtractionEdge)e.getEdge();
        if (oldEdge != null) {
            if (oldEdge.getTo().equals(this)) {     
                int v = ((OutputNodeModel)model).getValue();
                Node oldNode = e.getNode();
                int oldValue = 0;
                try {
                    oldValue = ((Integer)termsOfSum.get(oldNode.getID())).intValue();
                }
                catch (NullPointerException npe) {}
                if (oldEdge instanceof AdditionEdge)    
                    v = v - oldValue;
                else if (oldEdge instanceof SubtractionEdge)
                    v = v + oldValue;
                termsOfSum.remove(oldNode.getID());
                ((OutputNodeModel)model).setValue(v);
                view.setValue(v);
            }
            fireChangeEvent();
        } 
    }
   
    /* this is method is called if an InputNode or OutputNode pointing towards our node with an AdditionEdge or SubtractionEdge  
     * calls fireChangeEvent. We then change the model and view of our node, but do not have to notify the Matchmaker - the event
     * is either the result of a change in an InputNode (which already has informed the Matchmaker) or of an added or removed edge
     * which the synchronized JGraphs already are already informed of. In both cases, the local listener methods of a synchronized node
     * take effect
     */
    public void stateChanged(NeighborEvent e) { 
        StyledEdge edge = null;
        if (e.getEdge() instanceof AdditionEdge)
            edge=(AdditionEdge)e.getEdge();
        else if (e.getEdge() instanceof SubtractionEdge)
            edge=(SubtractionEdge)e.getEdge();
        if (edge== null)
            return;
        if (edge.getTo().equals(this)) {
            int v=((OutputNodeModel)model).getValue();
            Node node=e.getNode();
            int newValue=0;
            if (node instanceof InputNode || node instanceof OutputNode)
                newValue=((CalcNodeModel)node.getModel()).getValue();
            // obtain the node's old value
            int oldValue=((Integer)termsOfSum.get(node.getID())).intValue();
            
            // calculate the new value
            if (edge instanceof AdditionEdge)
                v = v + (newValue - oldValue);
            if (edge instanceof SubtractionEdge)
                v = v - (newValue - oldValue);
            termsOfSum.put(node.getID(), new Integer(newValue));
            ((OutputNodeModel)model).setValue(v);
            view.setValue(v);
            fireChangeEvent();
        }
    }
    
    // KeyListener implementation: //
 
    /* if the textField with the node's caption has been changed, a SyncEvent is fired */
    public void keyReleased(KeyEvent evt) {
        ((OutputNodeModel)this.model).setText(this.view.getText());
        if (getClient()!=null)
            getClient().changeObject(getLabel(),(java.io.Serializable)getModel(),false);
    }
    
    /* these KeyListener methods are not needed and thus implemented empty */
    public void keyPressed(KeyEvent evt) {}
    public void keyTyped(KeyEvent evt) {}
    
    public void localeChanged(LocaleEvent event) {
        java.util.Locale oldLocale = event.getOldLocale();
        prop.reloadBundle();
        changeLanguage(oldLocale);
    }
    

}

