package mypalettes.calc;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

public class InputNodePanel extends JPanel
{
    public static final Font DEFAULT_FONT=new Font("SansSerif",Font.BOLD,12);
    
    private JTextField textField, valueField;
    
    public InputNodePanel()
    { this("",0); }
    
    public InputNodePanel(String text, int value)
    { this(text,value,true); }
    
    public InputNodePanel(String text, int value, boolean editable)
    {
        textField=new JTextField(text);
        textField.setBackground(Color.green);
        textField.setBorder(null);
        valueField=new JTextField(Integer.toString(value));
        
        if (!editable) {
            textField.setEditable(false);
            valueField.setEditable(false);
        }
        setLayout(new BoxLayout(this,BoxLayout.Y_AXIS));
        add(textField);
        add(valueField);
        setBackground(Color.green);
    }

    public void addKeyListener(KeyListener l) {
        valueField.addKeyListener(l);
        textField.addKeyListener(l);
    }
    
    public void addChangeListener()
    {}
    
    public void setText(String text) {
        this.textField.setText(text);
    }
    
    public void setValue(String valueString) {
        this.valueField.setText(valueString);
    }
        
    public String getText()
    { return textField.getText(); }
    
    public int getValue()
    { return new Integer(valueField.getText()).intValue(); }
     
    
    public Insets getInsets()
    { return new Insets(8,8,8,8); }
}
