package info.collide.coolmodes.palettes.calc;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

import com.spiriteam.graph.*;
import com.spiriteam.sync.*;

import info.collide.xml.*;
import info.collide.locale.*;

public class InputNode extends AbstractNode implements KeyListener, LocaleListener {
    
    public static final String DEFAULT_TEXT="Input value";
    public static final int DEFAULT_VALUE=0;
    
    private InputNodeView view;
    
    protected CalcProp prop;
    
    public InputNode() {
        this(new InputNodeModel());
    }
    
    public InputNode(InputNodeModel model) {
        super(model);
        initView();
    }
    
    public InputNode(boolean createModel) {
      super(false);
      if (createModel)
          model = new InputNodeModel();
  }
    
    public void initView() {
        view = new InputNodeView(((InputNodeModel)model).getText(), ((InputNodeModel)model).getValue());
        view.setFont(InputNodeView.DEFAULT_FONT);
        view.addKeyListener(this);
        addPopupAction(new ResetInput());
        LocaleManager.getLocaleManager().addLocaleListener(this);
        updateBorder();
        super.initView();
    }
    
    public void setValue(int value) {
        ((InputNodeModel)model).setValue(value);
        view.setValue(value+"");
        if (getClient()!=null)
            getClient().changeObject(getLabel(),(java.io.Serializable)getModel(),false);
        fireChangeEvent();
    }
    
    private void changeLanguage(java.util.Locale oldLocale) {
        if (!((CalcNodeModel)model).getText().equals(prop.getProp("input.defaultname", oldLocale))) {
            return;
        }
        ((CalcNodeModel)model).setText(prop.getProp("input.defaultname"));
        view.setText(((CalcNodeModel)model).getText());
        //fireChangeEvent();
        if (getClient()!=null)
            getClient().changeObject(getLabel(),(java.io.Serializable)getModel(),false);
    }
    
    /* Returns the panel the user is interacting with. */
    public JComponent getUI()
    { return view; }
    
    // SyncListener implementation: //
    
    /* The synchronized server-side model has changed => update the local model and the view and fire a ChangeEvent so that all the
     * OutputNodes in the chain that are affected by the change of the InputNode model are notified and can locally change their
     * model (and their view)
     */
    public void objectChanged(SyncEvent evt) {
        InputNodeModel model=(InputNodeModel)evt.getObject();
        ((InputNodeModel)this.model).setText(model.getText());
        ((InputNodeModel)this.model).setValue(model.getValue());
        
        view.setText(model.getText());
        view.setValue(String.valueOf(model.getValue()));
        fireChangeEvent();
    }
    
    /* the other three SyncListener methods are not needed and thus implemented empty */
    public void objectCreated(SyncEvent event){}
    public void objectDeleted(SyncEvent evt) {}
    public void actionExecuted(SyncActionEvent event){}
    
    // KeyListener implementation: //
    
    /* if the content of the text field cannot be converted to an integer, the value is by default set to 0. After each change of
     * content in the text field we notify the Matchmaker of a change in our model and fire a local ChangeEvent to notify all
     * OutputNodes that are pointed towards from our node by an addition or subtraction edge.
     */
    public void keyReleased(KeyEvent evt) {
        int value = 0;
        try {
            value = this.view.getValue();
        }
        catch(NumberFormatException nfe) {
            this.view.setValue("0");
        }
        ((InputNodeModel)this.model).setText(this.view.getText());
        ((InputNodeModel)this.model).setValue(value);
        
        if (getClient()!=null)
            getClient().changeObject(getLabel(),(java.io.Serializable)getModel(),false);
        fireChangeEvent();
    }
    
    /* these KeyListener methods are not needed and thus implemented empty */
    public void keyPressed(KeyEvent evt) {}
    public void keyTyped(KeyEvent evt) {}
    
    public void localeChanged(LocaleEvent event) {
        java.util.Locale oldLocale = event.getOldLocale();
        prop.reloadBundle();
        changeLanguage(oldLocale);
    }
    
}