/*
 * CalcRefFrame.java
 */

package info.collide.coolmodes.palettes.calc;

import info.collide.coolmodes.core.*;
import info.collide.coolmodes.shared.*;
import info.collide.locale.*;
import com.spiriteam.graph.*;
import java.util.*;

/**
 *
 * @author  westheide/schmidt
 */
public class CalcRefFrame extends AbstractReferenceFrame implements LocaleListener {
// fields
    /* for accessing the properties file containing all localized strings */
    protected CalcProp prop;

// constructors
    /** Creates a new instance of CalcRefFrame */
    public CalcRefFrame() {
        palette = new CalcPalette();
    }
    
// methods
    public void init(GraphApplication manager) {
        super.init(manager);
        prop.reloadBundle();
        ((CalcPalette)palette).init();
        LocaleManager.getLocaleManager().addLocaleListener(this);
    }

    public String[] getPackagePrefixes() {
        String[] s = {"info.collide.coolmodes.palettes.calc"};
        return s;
    }

    public String getIdentifier() {
        return "Graphical Calculator";
    }

    /* For drag-and-drop functionality, we must return a model-node association for InputNode and OutputNode */
    public Association[] getNodeAssociations() {
        Association[] list = new Association[2];
        list[0] = new Association(InputNodeModel.class,InputNode.class);
        list[1] = new Association(OutputNodeModel.class,OutputNode.class);
        return list;
    }
    
    /* we won't be able to drag our edges in the workspace without associating the model and edge classes. */
    public Association[] getEdgeAssociations() {
        Association[] list = new Association[2];
        list[0] = new Association(AdditionEdgeModel.class,AdditionEdge.class);
        list[1] = new Association(SubtractionEdgeModel.class, SubtractionEdge.class);
        return list;
    }
    
    /* Here we define all edge rules, including ForbiddenCycleRules, that our palette wants the JGraph to apply. */
    public Rule[] getRules() {
        Rule[] rules = new Rule[6];
        Locale es = new Locale("es");
        rules[0] = new EdgeRule(null, new InputNode(), null, 0,
                    new LocalizedMessage(prop.getProp("rule.0", Locale.ENGLISH), prop.getProp("rule.0", Locale.GERMAN), prop.getProp("rule.0", es)));
        rules[1] = new EdgeRule(new InputNode(), new OutputNode(), null, 1,
                    new LocalizedMessage(prop.getProp("rule.12", Locale.ENGLISH), prop.getProp("rule.12", Locale.GERMAN), prop.getProp("rule.12", es)));
        rules[2] = new EdgeRule(new OutputNode(), new OutputNode(), null, 1,
                    new LocalizedMessage(prop.getProp("rule.12", Locale.ENGLISH), prop.getProp("rule.12", Locale.GERMAN), prop.getProp("rule.12", es)));
        rules[3] = new EdgeRule(null, null, new AdditionEdge(), 0,
                    new LocalizedMessage(prop.getProp("rule.3", Locale.ENGLISH), prop.getProp("rule.3", Locale.GERMAN), prop.getProp("rule.3", es)));
        rules[4] = new EdgeRule(null, null, new SubtractionEdge(), 0,
                    new LocalizedMessage(prop.getProp("rule.4", Locale.ENGLISH), prop.getProp("rule.4", Locale.GERMAN), prop.getProp("rule.4", es)));
        Edge[] edges = { new AdditionEdge(), new SubtractionEdge() };
        rules[5] = new ForbiddenCycleRule(edges,
            new LocalizedMessage(prop.getProp("cyclerule.0", Locale.ENGLISH), prop.getProp("cyclerule.0", Locale.GERMAN), prop.getProp("cyclerule.0", es)));
        return rules;
    }

    public void localeChanged(LocaleEvent event) {
        prop.reloadBundle();
        ((CalcPalette)palette).changeLanguage();
    }
    
}
