/*
 * CalcNodeModel.java
 *
 * Created on 21. Oktober 2002, 10:00
 */

package info.collide.coolmodes.palettes.calc;

import com.spiriteam.naming.*;
import com.spiriteam.graph.*;

import org.w3c.dom.*;

import java.io.*;

/**
 *
 * @author  westheide
 */
public class CalcNodeModel extends AbstractModel implements Serializable {
    
    protected String text;
    protected int value;
    
    public CalcNodeModel() {
        super();
    }
    
    public CalcNodeModel(UniqueID id) {
        super(id);
    }
    
    public CalcNodeModel(String text, int value, UniqueID id) {
        super(id);
        this.text=text;
        this.value=value;
    }
    
    public CalcNodeModel(String text, int value) {
        this(text, value, new UniqueID());
    }
    
    public String getText()
    { return text; }
    
    public void setText(String str)
    { this.text=str; }
    
    public int getValue()
    { return value; }
    
    public void setValue(int val)
    { this.value=val; }
    
    /* writes the <InputNode> XML tag with the important information on the node ID, the text and the value as attributes. */
    public void writeXMLAttributes(Element element) {
        super.writeXMLAttributes(element);
        element.setAttribute("text", getText());
        element.setAttribute("value",String.valueOf(getValue()));
    }
    
}
