package info.collide.coolmodes.core;

import com.spiriteam.graph.Rule;

import info.collide.coolmodes.shared.Association;

public interface ReferenceFrame {
    
  /** Called once when the ReferenceFrame is initialized (typically used 
   *  to set the PaletteHandler and to give the ReferenceFrame the opportunity to 
   *  check currently available graphs and draw-areas.
   **/
  public void init(GraphApplication manager);
  
   /** Called each time a graph or a draw-area has been added or removed. The Reference Frame 
    * can consult the PaletteHandler to keep track of this.
   **/
  public void update();
  
  /** The Reference Frame has been removed by the user.
   **/
  public void dispose();
  
  /** Returns the UI of the Reference Frame (or null, if not available)
   **/
  public Palette getPalette();
  
  /** Returns all the packages that the xml parser should consider
   **/
  public String[] getPackagePrefixes();
  
  /** Returns all the (node model)-(node) associations. Needed for drag&drop.
   *  If no nodes are used, return an empty array.
   **/
  public Association[] getNodeAssociations();
  
  /** Returns all the (edge model)-(edge) associations.
   *  If no edges are used, return an empty array.
   **/
  public Association[] getEdgeAssociations();
   
  /** Returns an identifier (must be unique but still telling...) of the Reference Frame.
   **/
  public String getIdentifier();
  
  /** Returns all the rules that this Reference Frame defines. Rules can be EdgeRules or
   * ForbiddenCycleRules currently.
   **/
  public Rule[] getRules();
  
  /** A description of where to find this Reference Frame - currently, either a class
   * file location or an xml file location */
  public String getLocation();
    
}




