package info.collide.coolmodes.core;

import java.awt.Component;

import javax.swing.Icon;

public interface Palette {
    
  /** The Palette has been selected by the user.
   **/
  public void enterPalette();
  
  /** The Palette has been deselected by the user.
   **/
  public void leavePalette();
  
  /** Returns the UI of the Palette - should be a Swing component, although not neccessary.
   **/
  public Component getUI();
  
  /** Returns the tooltip text for the palette.
   **/
  public String getToolTipText();
  
  /** The Icon of the palette.
   **/
  public Icon getIcon();
  
  /** Called by the system if the Palette has to switch to node mode.
   **/
  public void setNodeModeUI();
  
}

