package info.collide.coolmodes.core;

import java.util.*;
import java.awt.*;

import javax.swing.*;

import com.spiriteam.graph.*;
import com.spiriteam.draw.*;

import info.collide.coolmodes.shared.*;

import org.w3c.dom.*;

public abstract class AbstractPalette implements Palette {
    protected GraphApplication manager;
    // for loading documents:
    private String[] prefixes = new String[0];

    protected AbstractPalette(GraphApplication manager) {
        this.manager = manager;
    }

    protected AbstractPalette() {}

    public void enterPalette() {}

    public void leavePalette() {}

    public String getToolTipText() {
        return "Abstract";
    }

    public Icon getIcon() {
        return new ImageIcon(Toolkit.getDefaultToolkit().getImage(
        ClassLoader.getSystemClassLoader().getResource(getIconLocation())));
    }

    protected String getIconLocation() {
        return "info/collide/coolmodes/resources/ui/default_palette.gif";
    }

    public abstract Component getUI();

    public void setNodeModeUI() {}

    //
    // ... some convenience methods often needed :
    //

    public void setHandler(GraphApplication manager)  {
        this.manager = manager;
    }

    protected void toNodeMode() {
        manager.setNodeMode();
    }

    protected void toDrawMode() {
        manager.setDrawMode();
    }

    protected void toEdgeMode(Edge e) {
        manager.setEdgeMode(e);
    }

    protected void toEdgeMode(Edge e, boolean once) {
        if (once) manager.setEdgeMode(e,true,this);
        else manager.setEdgeMode(e);
    }

    protected void activateLastWorkspace() {
        manager.activateLastWorkspace();
    }

    protected JGraph loadJGraph(String location) {
        JGraph jgraph = JGraphLoader.loadJGraph(
        ClassLoader.getSystemClassLoader().getResourceAsStream(location), prefixes);
        jgraph.setPopupEnabledRecursively(false);
        return jgraph;
    }

    // used to allow the palette loading of xml documents without specifying a package
    void setPackagePrefixes(String[] prefixes) {
        this.prefixes = prefixes;
    }

  }
