# This is George Logemann's incremental compile and link makefile for
# CMT programs compiled with Microsoft Quick C.  George says incremental
# compile and link is a big time-saver.  -RBD

# cmt icompile, ilink
# 23-Feb-94 -- default PROJ is test; macro $D passed to compiler
# 01-Mar-94 -- qlink: no /NOE; icomp: use W4
# 13-Mar-94 -- special for Howard

# development directory
# SLIB = ..\
SLIB = 

# .exe file name
VERS =
PROJ = mtest$(VERS)

# component .obj's, define others than test#.obj in OBJSX
OBJS = $(OBJSX) $(PROJ).obj

# to create incremental compile and link; override with DEBUG=0 for release
DEBUG = 1

# to indicate a fast disk with inccludes and libraries
ONH = 0

# location of include files
!IF $(ONH)
ILIB = h:\h
!ELSE
# if more than one, can't use this, but must modify CFLAGS_G
ILIB = $(SLIB)
!ENDIF

# location of library files
!IF $(ONH)
LLIB = h:\lib
!ELSE
# if more than one, can't use this, but must modify LIBS
LLIB = $(SLIB)
!ENDIF

# location of compiler graphics library -- others via environment
!IF $(ONH)
QC25 = h:\lib
!ELSE
QC25 = c:\qc25\lib
!ENDIF

# include files as needed for source dependency
# H = $(SLIB)\xxxx.h $(SLIB)\xxxx.h
# H = $(ILIB)\xxxx.h $(ILIB)\xxxx.h

# CMT source library
CMTV = -j93
# CMTS = \music\cmt\$(CMTV)\lib\
CMTS = \music\cmt\lib\

# M is the memory model
M = L

# L is the log option
L = >> xlog

# P is the map option
# no map
P = NUL
# short map
# P = $(PROJ)
# extended map
# P = $(PROJ)/m

# compiler flags, etc.

# select the compiler
CC  = qcl $L

# general compiler flags
# CFLAGS_G  = $D /A$M /batch /c /nologo /I$(SLIB) /I$(CMTS)
# CFLAGS_G  = $D /A$M /batch /c /nologo /I$(ILIB)
# CFLAGS_G  = $D /A$M /batch /c /nologo
CFLAGS_G  = $D /A$M /batch /c /nologo /I$(CMTS)

# for incremental compiling
# CFLAGS_D  = /Zi /Zr /Gi$(PROJ).mdt /Od /W1
CFLAGS_D  = /Zi /Zr /Gi$(PROJ).mdt /Od /W4

# for release
CFLAGS_R  = /Ox /W1

# for library
CFLAGS_L  = /Zl

# for application
CFLAGS_A  =

# linker flags, etc.

# for map
MAPFILE   = $P

# general linker flags
# LFLAGS_G  = /NOI /BATCH /E /NOE
LFLAGS_G  = /NOI /BATCH /E

# for incremental linking and debugging
LFLAGS_D  = /INC /PADC:0x1000 /PADD:0x1000

# for release
LFLAGS_R  = 

# select flags per level of release

!IF $(DEBUG)
CFLAGS    = $(CFLAGS_G) $(CFLAGS_D) $(CFLAGS_A)
LFLAGS    = $(LFLAGS_G) $(LFLAGS_D)
!ELSE
CFLAGS    = $(CFLAGS_G) $(CFLAGS_R) $(CFLAGS_A)
LFLAGS    = $(LFLAGS_G) $(LFLAGS_R)
!ENDIF

# libraries

!IF $(ONH)
# LIBS = $(ILIB)\setilib.lib $(ILIB)\cmtlib.lib $(ILIB)\graphics.lib 
!ELSE
# LIBS = $(SLIB)\setilib.lib $(CMTS)\cmtlib.lib $(QC25)\graphics.lib 
LIBS = $(CMTS)\cmtlib.lib $(QC25)\graphics.lib 
!ENDIF

# default dependency is the project

all: $(PROJ).exe

# special dependencies

# etc.obj: etc.c $H

.c.obj :
#	to time each compile
#	ncc /start >nul
	$(CC) $(CFLAGS) $*.c
#	ncc /stop >>xlog

$(PROJ).exe : $(OBJS) $(LIBS)
	@echo>NUL <<$(PROJ).lrf
$(OBJS: = +^
)
$@
$(MAPFILE)
$(LIBS: = +^
)
;
<<
#	to time link
#	ncc /start >nul
	@echo>>xlog $@
!IF $(DEBUG)
	ilink -av -e "qlink $(LFLAGS) @$(PROJ).lrf" -nologo $(PROJ)
!ELSE
	qlink $L $(LFLAGS) @$(PROJ).lrf
!ENDIF
#	ncc /stop >>xlog

run: $(PROJ).exe
	$(PROJ).exe $(RUNFLAGS)

# ====
