/*
** Millisecond timing routines, for Microsoft C V6.0 and Turbo C.
*/
#include        <dos.h>
#include        "timer.h"
/* nix commented this section out.  Apparently, the compiler can handle all the
 assembler here, so it isn't necessary to invoke this pragma. I'll leave these
 comments until this is confirmed. -RBD
#ifdef __BORLANDC__
#pragma         inline
#endif
*/
#ifdef __TURBOC__
#define _asm asm
#endif

#define TimerResolution    1193L

unsigned long cardinal(long l)
{
	return((unsigned long) ((l < 0) ? 4294967295L + (long) ++l: (long) l));
}

unsigned long
elapsedtime(long start, long stop)
{
	return((unsigned long) (cardinal(stop - start) / TimerResolution));
}

void
initializetimer(void)
{
	outp(0x043,0x034);
	_asm {
		 jmp short NullJump1
	}
NullJump1:       
	outp(0x040,0x000);
	_asm {
		jmp short NullJump2
	}
NullJump2:
	outp(0x040,0x000);
}

void
restoretimer(void)
{
	outp(0x043,0x036);
	_asm {
		jmp short NullJump1
	}
NullJump1:
	outp(0x040,0x000);
	_asm {
		jmp short NullJump2
	}
NullJump2:
	outp(0x040,0x000);
}

#ifndef _MSC_VER
#pragma warn -rvl       /* shut up Turbo C warning about return value */
#endif
long readtimer(void)
{
	_asm {
	cli                             /* Disable interrupts */
	mov  dx,020h            /* Address PIC ocw3   */
	mov  al,00Ah            /* Ask to read irr    */
	out  dx,al
	mov  al,00h             /* Latch timer 0 */
	out  043h,al
	in   al,dx              /* Read irr      */
	mov  di,ax              /* Save it in DI */
	in   al,040h            /* Counter --> bx*/
	mov  bl,al              /* LSB in BL     */
	in   al,040h
	mov  bh,al              /* MSB in BH     */
	not  bx                 /* Need ascending counter */
	in   al,021h            /* Read PIC imr  */
	mov  si,ax              /* Save it in SI */
	mov  al,00FFh           /* Mask all interrupts */
	out  021h,al
	mov  ax,040h            /* read low word of time */
	mov  es,ax              /* from BIOS data area   */
	mov  dx,es:[06Ch]
	mov  ax,si              /* Restore imr from SI   */
	out  021h,al
	sti                             /* Enable interrupts */
	mov  ax,di              /* Retrieve old irr  */
	test al,001h            /* Counter hit 0?    */
	jz   done                       /* Jump if not       */
	cmp  bx,0FFh            /* Counter > 0x0FF?    */
	ja   done                       /* Done if so        */
	inc  dx                 /* Else count int req. */
	}
done:
	_asm {
	mov ax,bx                       /* set function result */
	}
}
#ifndef _MSC_VER
#pragma warn .rvl       /* reset Turbo C return value warning */
#endif
