PROJ = CMTLIB
DEBUG = 0
OBJS  = CEXT.obj CLEANUP.obj CMTCMD.obj TIMER.obj TIMEBASE.obj TEMPOMAP.obj\
	SEQWRITE.obj SEQEXTNS.obj SEQREAD.obj SEQ.obj RECORD.obj MPU.obj\
	MOXCMAIN.obj MIDIFNS.obj SEQMREAD.obj SEQMWRIT.obj CMDLINE.obj\
	EXCLDESC.obj MEM.obj MOXC.obj USERIO.obj MIDIFILE.obj

# M is the memory model
M       = L

# L is the log option
L       = >> xlog

# P is the extended map option
P       = /m

# select the compiler
CC  = qcl $L

# general compiler flags
CFLAGS_G  = /A$M /batch /c /nologo

# for debugging
CFLAGS_D  = /Zr /Od /W4

# for running
CFLAGS_R  = /Ox /W1

# for library
CFLAGS_L  = /Zl

# for application
CFLAGS_A  =

LIB = lib $L
LIBFLAGS = /nol
LRF  = echo > NUL

all: $(PROJ).lib

.c.obj :
!IF $(DEBUG)
	$(CC) $(CFLAGS_G) $(CFLAGS_D) $(CFLAGS_L) $*.c
!ELSE
	$(CC) $(CFLAGS_G) $(CFLAGS_R) $(CFLAGS_L) $*.c
!ENDIF

$(PROJ).lib : $(OBJS)
	$(LRF) @<<$(PROJ).lrf
$(RT_OBJS: = &^
+) +$(OBJS: = &^
+) ;
<<
	del $@
	$(LIB) $* $(LIBFLAGS) @$(PROJ).lrf


