/* LightspeedC function prototype header file.

Copyright (c)1986. THINK Technologies, Inc. All rights reserved.


This file contains the function prototypes for all (hopefully) of the
published LightspeedC library functions.  It can be dissected into
whatever pieces are desired or it can simply be included (at some extra
cost in time to compile and symbol table overhead).

Since the original header files have not been modified, they can still be
included in conjunction with this prototype header, if desired.  That
means that you could still include "math.h" for its definition of PI and
such and follow that with an include of this file.

The prototypes are presented here in no particular order, however, they are
grouped by originating library.

*/
#ifdef THINK3
#ifndef _fopenwh_
#include "fopenw.h"
#endif
#endif

#ifndef _EventMgr_
#include "EventMgr.h"
#endif


/* math.h */

int abs(int x);
double acos(double x);
double asin(double x);
double atan(double x);
double atan2(double y, double x);
double ceil(double x);
double cos(double x);
double cosh(double x);
double exp(double x);
double fabs(double x);
double floor(double x);
double fmod(double x, double y);
double frexp(double x, int *nptr);
long int labs(long int x);
double ldexp(double x, int n);
double log(double x);
double log10(double x);
double modf(double x,int *nptr);
double pow(double x, double y);
int rand(void);
double sin(double x);
double sinh(double x);
double sqrt(double x);
void srand(unsigned int seed);
double tan(double x);
double tanh(double x);

/* strings.h */
#ifndef _H_string

int stccpy(char *s1, char *s2, int n);
int stcis(char *s, char *set);
int stcisn(char *s1, char *set);
int stclen(char *s);
char *stpblk(char *p);
char *stpbrk(char *s, char *set);
char *stpchr(char *s, char c);
char *stpcpy(char *s1, char *s2);
char *strcat(char *s1, char *s2);
char *strchr(char *s, char c);
int strcmp(char *s1, char *s2);
char *strcpy(char *s1, char *s2);
int strcspn(char *s, char *set);
int strlen(char *s);
char *strncat(char *s1, char *s2, int n);
int strncmp(char *s1, char *s2, int n);
char *strncpy(char *s1, char *s2, int n);
char *strpbrk(char *s, char *set);
int strpos(char *s, char c);
char *strrchr(char *s, char c);
char *strrpbrk(char *s, char *set);
int strrpos(char *s, char c);
int strspn(char *s, char *set);
int stscmp(char *s1, char *s2);
#endif

/* unix_strings.h */

int stcarg(char *s, char *b);
int stcpm(char *s, char *p, char **q);
int stcpma(char *string, char *pattern);
char *stpsym(char *s, char *sym, int symlen);
char *stptok(char *s, char *tok, int toklen, char *brk);

/* storage.h */

void *clalloc(unsigned long count,unsigned long size);
void *calloc(unsigned int count, unsigned int size);
int free(void *ptr);
int cfree(void *ptr);
void *mlalloc(unsigned long size);
char *malloc(unsigned long size);
void *relalloc(void *ptr,unsigned long newsize);
void *realloc(void *ptr,unsigned newsize);

/* storageu.h */

int     allmem(void);
int bldmem(int n);
char *getmem(unsigned int nbytes);
char *getml(unsigned long lnbytes);
char *lsbrk(unsigned long lnbytes);
int     rlsmem(char *cp, unsigned int nbytes);
int     rlsml(char *cp,unsigned long lnbytes);
void rstmem(void);
void rbrk(void);
char *sbrk(unsigned int nbytes);
long sizmem(void);

/* unix.h */

#ifndef _stdioh_
#include "stdio.h"
#endif _stdioh_

char *locv(int hi,int lo);
int getw(FILE *who);
int putw(int word, FILE *who);
void perror(char *s);

void sleep(int secs);
int ttyn(FILE *who);
int stspfp(char *p,int *n);

double atof(char *s);
int atoi(char *s);
long atol(char *s);

int execl(char *path, ...);
int execv(char *path, char *argv[]);
int execle(char *path, ...);
int execve(char *path, char *argv[], char *envp[]);

void exit(...);
void _exit(...);
void abort(...);


int     fileno(FILE *who);
int open(char *filename, int mode);
int close(int fildes);
int read(int fildes, char *buffer, unsigned nbytes);
int write(int fildes, char *buffer, unsigned nbytes);
long lseek(int fildes, long int offset, unsigned int offsetmode);
long tell(int fildes);
int     rename(char *old, char *new);
int     remove(char *name);
int     unlink(char *name);
int creat(char *filename, int mode);

int getuid(void);
int setuid(int uid);
int getpid(void);
int setpid(int pid);
char *cgetpid(char *sptr);

void setmem(char *p,unsigned n,char c);
void repmem(char *s, char *v, int lv, int nv);
void movmem(char *s, char *d, unsigned n);

void eraseplot(void);
void line(int x1, int y1, int x2, int y2);
void move(int x, int y);
void circle(int x, int y, int r);
void cont(int x, int y);
void point(int x, int y);
void label(char *s);

#ifdef THINK3
int setbuf(FILE *fp, char *buf);
#endif
int setnbuf(FILE *fp);

int (*signal(int sig, int (*func)()))();
int kill(int pid, int sig);

int stci_d(char *out, int in, int outlen);
int stcu_d(char *out, unsigned int in, int outlen);

int stcd_i(char *s,int *r);
int stch_i(char *s,int *r);

unsigned long time(unsigned long *clock);
char *ctime(unsigned long *clock);
struct tm *localtime(unsigned long *clock);
struct tm *gmtime(unsigned long *clock);
char *asctime(struct tm *UnixTimeRecp);

/* stdio */

#ifdef THINK3
int     feof(FILE *who);
int     ferror(FILE *who);
void clearerr(FILE *who);
void clrerr(FILE *who);

int     fseek(FILE *who, long offset, int type);
long ftell(FILE *who);
int     fflush(FILE *who);
void rewind(FILE *who);

int     fwrite(char *ptr, unsigned size, int count, FILE *who);
int     fread(char *ptr, unsigned size, int count, FILE *who);

int     fgetc(FILE *who);
char *fgets(char *s, int n, FILE *who);
char *gets(char *s);
int     ungetc(char c, FILE *who);

int ungetch(int c);
int getch(void);
int getche(void);
char *cgets(char *s);

/*      For 3.0, these are macros.
int     min(int v1, int v2);
int     max(int v1, int v2);
*/

int     fclose(FILE *who);
FILE *fopen(char *nameptr, char *type);
FILE *freopen(char *nameptr, char *type, FILE *who);
int     _closeall(void);

int     fputc(unsigned char c, FILE *who);
int     fputs(char *s, FILE *who);
int puts(char *s);

void cputs(char *s);
void wputs(char *s);
int     kbhit(void);


int     toint(char c);
int     toupper(char c);
int     tolower(char c);
int     _toupper(char c);
int     _tolower(char c);
int     isupper(char c);
int     islower(char c);

char *std_ver(void);

int printf(char *fmt, ...);
int vprintf(char *fmt, char *arr, ...);
int fprintf(FILE *who, char *fmt, ...);
int vfprintf(FILE *who, char *fmt, char *arr, ...);
int cprintf(char *fmt, ...);
int vcprintf(char *fmt, char *arr, ...);

int sprintf(char *dest, char *fmt, ...);
int vsprintf(char *dest, char *fmt, char *arr, ...);

int scanf(char *fmt, ...);
int cscanf(char *fmt, ...);
int fscanf(FILE *who, char *fmt, ...);
int sscanf(unsigned char *dest, char *fmt, ...);

Boolean StdEvent(EventRecord *event);
FILE *fopenw(char *titlebar, Point upper_left, StdWindowOptions *opts);
char *Get_ScreenPtr(void);
setwindow(FILE *windowfile);
void Click_On(int flag);
void Stdio_Config(int font, int size, int face, int mode);
void Stdio_config(int font, int size, int face, int mode);
void Set_Echo(Boolean state);
void Stdio_MacInit(Boolean flag);
void Set_Tab(int len);
void gotoxy(int x, int y);
int getxpos(void);
int getypos(void);
void putch(char c);
#endif

void SetFPU(int IsUsingFPU);

#ifndef _setjmph_
#include "setjmp.h"
#endif _setjmph_

int setjmp(jmp_buf env);
void longjmp(jmp_buf env, int val);
