/******************************************************************************
*
*   Source Control
*   --------------
* Copyright (c) 1988 Commodore-Amiga, Inc.
* 
* Executables based on this information may be used in software
* for Commodore Amiga computers.  All other rights reserved.
* 
* This code based on Commodore's propjoy.c program, which carries
* the Copyright info listed above.
*
******************************************************************************/

#include <exec/types.h>
#include <exec/nodes.h>
#include <exec/execname.h>

#include <graphics/gfxbase.h>
#include <graphics/graphint.h>

#include <hardware/cia.h>
#include <hardware/custom.h>
#include <hardware/intbits.h>

#include <resources/potgo.h>

#include "camd.h"
#include "camdfns.h"
#include "prop1.h"
#include "cleanup.h"

#define REV (0L)

/* use system defined addresses for potgo and pot1dat */

#define POTGO       &custom.potgo
#define POT0DAT     &custom.pot0dat
#define POT1DAT     &custom.pot1dat
#define JOY0DAT     custom.joy0dat
#define JOY1DAT     custom.joy1dat

/* vertical blank interrupt server priority   */

#define HIGHINTPRI 127L     /* needs to be replaced with priority relative */
#define LOWINTPRI -127L     /* needs to be replaced with priority relative */

#define NUM_SERVERS 2

/* bit number defines for potgo ... */

#define START_B     0   

#define DATRX_B     8   
#define DATRY_B     10

#define DATLX_B     12  
#define DATLY_B     14

/* masks ... */

#define START_F     (1L << START_B)
#define DATRX_F     (1L << DATRX_B)
#define DATRY_F     (1L << DATRY_B) 
#define DATLX_F     (1L << DATLX_B)
#define DATLY_F     (1L << DATLY_B) 

#define RPOTX       (START_F | DATRX_F) 
#define RPOTY       (START_F | DATRY_F) 
#define RPOTXY      (START_F | DATRX_F | DATRY_F) 

#define LPOTX       (START_F | DATLX_F) 
#define LPOTY       (START_F | DATLY_F) 
#define LPOTXY      (START_F | DATLX_F | DATLY_F) 

extern struct MidiInterface *cmt_mi;

extern struct GfxBase *GfxBase = NULL;
struct PotgoBase *PotgoBase = NULL;

/* global storage for potdat */

UWORD oldbits = NULL;
UWORD potbits = NULL;

int prop_1_hysteresis = 0;
int prop_1_left_data = 0;
int prop_1_right_data = 0;
int prop_1_left_button = 0;
int prop_1_right_button = 0;
int prop_1_left_integral = 0;
int prop_1_right_integral = 0;
int prop_1_left_enable = 0;
int prop_1_right_enable = 0;
int prop_1_events = 0;
int prop_running = 0;

/* create server-task to read the proportional joysticks,*/ 
/* update potdat, and then poke potgo to start next data read */

/* reserve space for the interrupt servers */
struct Isrvstr server[NUM_SERVERS] = {NULL};

first_server(i)
int i;
{
/* these were declared register */
    int data;
    int delta;
    ULONG potdat;
#asm
	movem.l d2/d3/a4,-(sp)
	jsr _geta4#
#endasm

    /* read previous proportional joystick values */
    potdat = *(ULONG *)POT0DAT;

    /* poke potgo, restore old bits */
    WritePotgo(oldbits,((~1)<<8)|oldbits);

/*    if (prop_1_left_enable) { */
	data = (potdat >> 8) & 0xFF;
	delta = data - prop_1_left_data;
	if (delta < 0) delta = -delta;
	if (delta == 0) {
	    prop_1_left_integral = 0;
	} else {
	    prop_1_left_integral += delta;
	    if (prop_1_left_integral > prop_1_hysteresis) {
		prop_1_left_data = data;
		prop_1_events |= PROP_1_LEFT_CHANGE;
		Signal(cmt_mi->mi_SigTask, MIDISIG(cmt_mi));
		prop_1_left_integral = 0;
	    }
	    }
/*    } */

#ifdef OMIT
/*    if (prop_1_right_enable) { */
	data = potdat & 0xFF;
	delta = data - prop_1_right_data;
	if (delta < 0) delta = -delta;
	 if (delta == 0) {
	    prop_1_right_integral = 0;
	} else {
	    prop_1_right_integral += delta;
	    if (prop_1_right_integral > prop_1_hysteresis) {
		prop_1_right_data = data;
		prop_1_events |= PROP_1_RIGHT_CHANGE;
		Signal(cmt_mi->mi_SigTask, MIDISIG(cmt_mi));
		prop_1_right_integral = 0;
	    }
	    }
/*    } */
#endif
    ;
    ; /* sets jump point for conditional */
    ;
    /* be nice -- let other servers run, too */
#asm
	movem.l (sp)+,d2/d3/a4
	moveq.l #0,d0
#endasm
}

second_server(i)
int i;
{
#asm
	movem.l d2/d3/a4,-(sp)
	jsr _geta4#
#endasm
    /* poke potgo, start prop joystick read  */
    WritePotgo(potbits,((~1)<<8)|potbits);

    /* be nice -- let other servers run, too */
#asm
	movem.l (sp)+,d2/d3/a4
	moveq.l #0,d0
#endasm
}


third_server(i)
int i;
{
    return 0;
}

void prop_poll()
{
    register int data;
    data = (JOY1DAT >> 9) & 1;
    if (data != prop_1_left_button) {
	prop_1_left_button = data;
	prop_1_events |= BUTTON_1_LEFT_CHANGE;
    }

    data = (JOY1DAT >> 1) & 1;
    if (data != prop_1_right_button) {
	prop_1_right_button = data;
	prop_1_events |= BUTTON_1_RIGHT_CHANGE;
    }
}


int prop_init()
{
    if (prop_running) return;
    prop_running = 1;

    /* set server priorities */ 
    server[0].is_Node.ln_Pri = HIGHINTPRI;  
    server[1].is_Node.ln_Pri = LOWINTPRI;   

    if ((GfxBase = (struct GfxBase *)
	  OpenLibrary("graphics.library", REV)) != NULL) {
	if ((PotgoBase = (struct PotgoBase *) 
	      OpenResource(POTGONAME, REV)) != NULL) {
	    /* remember currently used bits */
	    oldbits = ~(AllocPotBits(~1));

	    /* restore previous state of bit allocation */
	    FreePotBits(~oldbits);

	    /* now attempt to allocate start potbit */
	    potbits = AllocPotBits(START_F);

	    Forbid();   

	    /* add interrupt servers */

	    AddTOF(&server[0], third_server, 0);

/*          AddTOF(&server[1], third_server, 1); */

	    Permit();
	    cu_remember(prop_term, NULL);
	    return TRUE;
	}
    } 
    return FALSE;
}


void prop_term()
{
    if (!prop_running) return;
    prop_running = 0;
    
    Forbid();   
    RemTOF(&server[0]);
/*    RemTOF(&server[1]); */

    Permit();

    /* free potbits */

    FreePotBits(potbits);
}
