#ifdef PT
#include "switches.h"
#include "cext.h"
#include "stdio.h"
#include "cmdline.h"
#include "userio.h"

#include "pt.h"

/* these functions are copied from midifns.c - should
** be shared */
/* binary value of hex char */

private int xval(int c)
{
	int i;
	static char t[]="0123456789abcdef";

	for (i=0; i<16; i++)
		if(tolower(c)==t[i]) return(i);
	return (-1);
}
/* binary value of hex string */
private int atox(char *t)
{
	int		i=0;
	int		x;
	while(*t)
	{
		if ((x=xval(*t++))<0)return (0);
		i=(i<<4)+x;
	}
	return (i);
}

/* there could be another file equivalent to midifns.c
 * that did this */
/* ptInit -- initialize the PT interface */
void ptInit()
{
	int err;
	int base=PT_BASE;
	char *t;
	if (t=getenv("PTBASE")) {
		base=atox(t);
	}
	if (err = ptOpen(base)) {
		ptClose(err);
		EXIT(1);
	}
	cu_register((cu_fn_type) ptClose, 0);
}
#endif /* PT */
