/*
** PT.H defines the interface to the posicionador tridimensionale
** board.
**
**  ref: J. Martinez F., M. Fuentes C., M. Pena C.,
**       E. Martinez S., R. Osorio C., "Dispositivo Detector
**       de Posiciones Tridimensionales"
**
*/

#ifdef PT

/* Hardware details of interface */
/* the base address can be overridden with the env var PTBASE */
#define PT_BASE			0x0378	/* default base address */
#define PT_IRQ				3			/* hardwired */
/* briefly, the device asserts IRQ 3 at every vertical retrace of
** the video input, setting 5 registers: */
/* reading COORXL acknowledges the interrupt */
#define PT_COORXL			0  /* low byte of the X coordinate */
#define PT_COORXH			1  /* high byte of the X coordinate */
#define PT_COORY			2  /* the Y coordinate */
#define PT_COORZL			4  /* low byte of the area */
#define PT_COORZH			5  /* high byte of the area */

#ifndef FALSE
#define FALSE 0					/* boolean constants */
#define TRUE !(FALSE)
#endif

#ifndef PICCNTRL		/* these are also defined in mpu.h */
#define PICCNTRL		0x0020	/* Programmable Interrupt Controller address */
#define PICIMR			0x0021	/* PIC interrupt mask register */
#define PICCNTRL_AT		0x00A0	/* AT Programmable Interrupt Controller address */
#define PICIMR_AT		0x00A1	/* AT PIC interrupt mask register */
#define EOI				0x20	/* Non-specific End Of Interrupt */
#endif /* undef(PICCNTRL) */

/* error codes set back by ptOpen */
#define PTINITED		0		/* PT properly installed */
#define PTBASE_ERR  	1		/* Illegal base addr request */

/*************************
* PT data type  			 *
*************************/

typedef struct {
	unsigned int x;
	unsigned int y;
	unsigned int a;
} pt_value;

/*************************
* access to PT 			 *
*************************/

void ptInit();
void ptGetData(pt_value *);
int  ptOpen(unsigned int);
int  ptClose(int);

/*************************
* PT error flags			 *
*************************/
extern short pt_error_flags;
#define PTBUFFOVFL 1				/* input buffer overflow */

#endif /* PT */
