/* repitch.c 1.00 -- Increase Pnnn by 12 */
/*
	Input:
		repitch <infile> <outfile> copies <infile>, presumably an Adagio
		source file (you must specify explicitly any .gio) to <outfile>,
		replacing any Pnnn or pnnn with Pmmm or pmmm, where mmm=nnn+12.
	Notes:
		Comments (lines beginning with *) are examined.
		Since the old Adagio's didn't handle nnn<0, no negative pitches
		are converted.
		Pitches above 115 are unchanged.
	Output:
		exit(0) if OK
		exit(1) if can't open input file
		exit(2) if can't open output file
		exit(3) if invoked incorrectly
		exit(4) if nnn has more than 9 digits ...
		exit(5) if cannot close output file
*/

#include "switches.h"
#include "stdio.h"
#ifdef THINK
#include "console.h"
#endif

main(argc,argv)
int             argc;
char    *argv[];
{
	char    numerals[10];
	int             c;
	int             i;
	int             newp;
	FILE    *ip;
	FILE    *op;
	char    *pgm="repitch";
#ifdef THINK
	/* Macintosh needs help to provide Unix-style command line */
	argc = ccommand(&argv);
#endif
	if (argc!=3)
	{
		fprintf(stderr,"usage: %s <infile> <outfile>\n", pgm);
		exit(3);
	}

	if (!(ip=fopen(argv[1],"r")))
	{
		fprintf(stderr,"%s: can't open file %s\n",pgm,argv[1]);
		exit(1);
	}
	if (!(op=fopen(argv[2],"w")))
	{
		fprintf(stderr,"%s: can't open file %s\n",pgm,argv[2]);
		exit(2);
	}

	/* scan for a pitch */

	while ((c=getc(ip))!=EOF)
	{
		fprintf(op,"%c",c);
		if (c=='P'||c=='p')
		{
			i=0;
			while((c=getc(ip))>='0'&&c<='9') numerals[i++]=(char)c;
			if (i>0)
			{
				if(i>9)
				{
					fprintf(stderr,"%s: unable to continue\n",pgm);
					exit(4);
				}
				numerals[i]='\0';
				newp=atoi(numerals);
				if (newp<=115)newp+=12;
				fprintf(op,"%d",newp);
			}
			if (c==EOF) break;
			fprintf(op,"%c",c);
		}
	}
	if(fclose(op))
	{
		fprintf(stderr,"%s: unable to close %s\n",pgm,argv[2]);
		exit(5);
	};
	exit(0);
}
