#include "musiprog.h"
#include "midicode.h"

char *app_syntax = "";

void keydown(int chan, int pitch, int vel)
{
    midi_note(chan, pitch, vel);
}

void keyup(int chan, int pitch)
{
    midi_note(chan, pitch, 0);
}

void ctrlchange(int ch, int c, int val)
{
    midi_ctrl(ch, c, val);
}

void peddown(int ch)
{
    midi_ctrl(ch, SUSTAIN, 127);
}

void pedup(int ch)
{
    midi_ctrl(ch, SUSTAIN, 0);
}

void prgmchange(int ch, int program)
{
    midi_program(ch, program);
}

void mainscore()
{
#ifdef MIDI_THRU
    midi_thru(false);
#endif
    cause(1000, mainscore);
}


/* asciievent -- ascii event handler */
/**/
void asciievent(char c)
{
	if (c == 'q') quit();
	else gprintf(TRANS, "Type q to quit.\n");
}


/* bendchange -- pitch bend handler */
/**/
void bendchange(int chan, int value)
{
	/* insert pitchbend actions here */
}


/* touchchange -- after touch handler */
/**/
void touchchange(int chan, int value)
{
	/* insert after touch actions here */
}


/* coda -- what to do at end of performance */
/*
 * NOTE: this is called just before closing down the midi interface.
 */
void coda(void)
{
}


/* midievent -- called when mididecode == false */
/**/
void midievent(data)
  unsigned char data[4];
{
}


/* sysex -- sysex message handler */
/**/
void sysex()
{
	/* Insert sysex actions here.
	   Hint: get the sysex message by calling getxbuf
	 */
}


#ifdef AMIGA
void buttonchange(number, value)
{
}

void propchange(number, value)
{
	/* insert propchange actions here */
}
#endif
